/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateUtil {
    private static final String DATE_ISO_FORMAT = "yyyy-MM-dd";
    private static final String DATE_TIME_ISO_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_ISO_FORMAT = "HH:mm:ss";
    private static final String INVALID_DATE_FORMAT = "invalid format 'YYYY-MM-DD' expected";
    private static final String INVALID_TIME_FORMAT = "invalid format 'HH:MM:SS' expected";
    private static final String INVALID_DATETIME_FORMAT = "invalid format 'YYYY-MM-DD HH:MM:SS' expected";

    private DateUtil() {
    }

    public static java.sql.Date todaySqlDate() {
        return new java.sql.Date(Calendar.getInstance().getTimeInMillis());
    }

    public static Date todayUtilDate() {
        return new Date(Calendar.getInstance().getTimeInMillis());
    }

    public static String todayString(String sFormat) {
        Date date = new Date(Calendar.getInstance().getTimeInMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat(sFormat);
        return dateFormat.format(date);
    }

    public static String format(int iDay, int iMonth, int iYear, String sFormat) {
        Date date = DateUtil.getUtilDate(iDay, iMonth, iYear);
        SimpleDateFormat dateFormat = new SimpleDateFormat(sFormat);
        return dateFormat.format(date);
    }

    public static String format(int iDay, int iMonth, int iYear) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_ISO_FORMAT);
        return dateFormat.format(DateUtil.getUtilDate(iDay, iMonth, iYear));
    }

    public static String format(Date date, String sFormat) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(sFormat);
        return dateFormat.format(date);
    }

    public static java.sql.Date getSqlDate(int iDay, int iMonth, int iYear) {
        Calendar cal = Calendar.getInstance();
        cal.set(iYear, iMonth - 1, iDay);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static Date getUtilDate(int iDay, int iMonth, int iYear) {
        Calendar cal = Calendar.getInstance();
        cal.set(iYear, iMonth - 1, iDay);
        return new Date(cal.getTimeInMillis());
    }

    public static int getDay(java.sql.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getMonth(java.sql.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getYear(java.sql.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static String dateISO(Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_ISO_FORMAT);
            return dateFormat.format(date);
        }
        return "";
    }

    public static String timeISO(Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_ISO_FORMAT);
            return dateFormat.format(date);
        }
        return "";
    }

    public static String dateTimeISO(Date date) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_TIME_ISO_FORMAT);
            return dateFormat.format(date);
        }
        return "";
    }

    private static void throwParseDateException(String sDate, String sMsg) {
        throw new RuntimeException("Cannot parse date '" + sDate + "' : " + sMsg);
    }

    private static void throwParseTimeException(String sTime, String sMsg) {
        throw new RuntimeException("Cannot parse time '" + sTime + "' : " + sMsg);
    }

    private static void throwParseDateTimeException(String sDateTime, String sMsg) {
        throw new RuntimeException("Cannot parse date & time '" + sDateTime + "' : " + sMsg);
    }

    public static Date parse(String sDate) {
        if (sDate == null) {
            return null;
        }
        String sTrim = sDate.trim();
        int length = sTrim.length();
        if (length == 0) {
            return null;
        }
        if (length == 10) {
            return DateUtil.parseDate(sTrim);
        }
        if (length == 8) {
            return DateUtil.parseTime(sTrim);
        }
        if (length == 19) {
            return DateUtil.parseDateTime(sTrim);
        }
        throw new RuntimeException("Cannot parse '" + sTrim + "' : invalid length");
    }

    public static Date parseDate(String sDate) {
        if (sDate == null) {
            return null;
        }
        if (sDate.length() == 0) {
            return null;
        }
        char c = '\u0000';
        for (int i = 0; i < 10; ++i) {
            c = sDate.charAt(i);
            if ((c < '0' || c > '9') && c != '-') {
                DateUtil.throwParseDateException(sDate, INVALID_DATE_FORMAT);
            }
            if (c != '-' || i == 4 || i == 7) continue;
            DateUtil.throwParseDateException(sDate, INVALID_DATE_FORMAT);
        }
        Date ret = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_ISO_FORMAT);
            dateFormat.setLenient(false);
            ret = dateFormat.parse(sDate);
        }
        catch (ParseException e) {
            DateUtil.throwParseDateException(sDate, "invalid date");
        }
        return ret;
    }

    public static Date parseTime(String sTime) {
        if (sTime == null) {
            return null;
        }
        if (sTime.length() == 0) {
            return null;
        }
        char c = '\u0000';
        for (int i = 0; i < 8; ++i) {
            c = sTime.charAt(i);
            if ((c < '0' || c > '9') && c != ':') {
                DateUtil.throwParseTimeException(sTime, INVALID_TIME_FORMAT);
            }
            if (c != ':' || i == 2 || i == 5) continue;
            DateUtil.throwParseTimeException(sTime, INVALID_TIME_FORMAT);
        }
        Date ret = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_ISO_FORMAT);
            dateFormat.setLenient(false);
            ret = dateFormat.parse(sTime);
        }
        catch (ParseException e) {
            DateUtil.throwParseTimeException(sTime, "invalid time");
        }
        return ret;
    }

    public static Date parseDateTime(String sDateTime) {
        if (sDateTime == null) {
            return null;
        }
        if (sDateTime.length() == 0) {
            return null;
        }
        char c = '\u0000';
        for (int i = 0; i < 19; ++i) {
            c = sDateTime.charAt(i);
            if ((c < '0' || c > '9') && c != '-' && c != ':' && c != ' ') {
                DateUtil.throwParseDateTimeException(sDateTime, INVALID_DATETIME_FORMAT);
            }
            if (c == '-' && i != 4 && i != 7) {
                DateUtil.throwParseDateTimeException(sDateTime, INVALID_DATETIME_FORMAT);
            }
            if (c == ' ' && i != 10) {
                DateUtil.throwParseDateTimeException(sDateTime, INVALID_DATETIME_FORMAT);
            }
            if (c != ':' || i == 13 || i == 16) continue;
            DateUtil.throwParseDateTimeException(sDateTime, INVALID_DATETIME_FORMAT);
        }
        Date ret = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_TIME_ISO_FORMAT);
            dateFormat.setLenient(false);
            ret = dateFormat.parse(sDateTime);
        }
        catch (ParseException e) {
            DateUtil.throwParseDateTimeException(sDateTime, "invalid date or time");
        }
        return ret;
    }
}

