/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.hibernate.boot.MetadataSources;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.n52.hibernate.spatial.dialect.TimestampMySQL8SpatialDialectNoComments;
import org.n52.hibernate.spatial.dialect.TimestampWithTimeZoneGeoDBDialectNoComments;
import org.n52.hibernate.spatial.dialect.TimestampWithTimeZoneOracleSpatial10gDialectNoComments;
import org.n52.hibernate.spatial.dialect.TimestampWithTimeZonePostgisPG95DialectNoComments;
import org.n52.hibernate.spatial.dialect.TimestampWithTimeZoneSqlServer2012SpatialDialectNoComments;
import org.n52.hibernate.spatial.dialect.h2geodb.TimestampWithTimeZoneGeoDBDialect;
import org.n52.hibernate.spatial.dialect.mysql.TimestampMySQL8SpatialDialect;
import org.n52.hibernate.spatial.dialect.oracle.TimestampWithTimeZoneOracleSpatial10gDialect;
import org.n52.hibernate.spatial.dialect.postgis.TimestampWithTimeZonePostgisPG95Dialect;
import org.n52.hibernate.spatial.dialect.sqlserver.TimestampWithTimeZoneSqlServer2008SpatialDialect;

public abstract class AbstractGenerator {
    protected static final String NEW_LINE = "\n";
    protected static final String PIPE = " | ";
    private final boolean print;

    protected AbstractGenerator() {
        this(true);
    }

    protected AbstractGenerator(boolean print) {
        this.print = print;
    }

    protected Dialect getDialect(DialectSelector selection, boolean comments) throws Exception {
        switch (selection) {
            case ORACLE: {
                return comments ? new TimestampWithTimeZoneOracleSpatial10gDialect() : new TimestampWithTimeZoneOracleSpatial10gDialectNoComments();
            }
            case GEODB_H2: {
                return comments ? new TimestampWithTimeZoneGeoDBDialect() : new TimestampWithTimeZoneGeoDBDialectNoComments();
            }
            case MYSQL: {
                return comments ? new TimestampMySQL8SpatialDialect() : new TimestampMySQL8SpatialDialectNoComments();
            }
            case SQL_SERVER: {
                return comments ? new TimestampWithTimeZoneSqlServer2008SpatialDialect() : new TimestampWithTimeZoneSqlServer2012SpatialDialectNoComments();
            }
        }
        return comments ? new TimestampWithTimeZonePostgisPG95Dialect() : new TimestampWithTimeZonePostgisPG95DialectNoComments();
    }

    protected int getDialectSelection() throws IOException {
        AbstractGenerator.printToScreen("This SQL script generator supports:");
        AbstractGenerator.printToScreen("0   PostgreSQL/PostGIS");
        AbstractGenerator.printToScreen("1   Oracle");
        AbstractGenerator.printToScreen("2   H2/GeoDB");
        AbstractGenerator.printToScreen("3   MySQL");
        AbstractGenerator.printToScreen("4   SQL Server");
        AbstractGenerator.printToScreen("");
        AbstractGenerator.printEnterYourSelection();
        return this.readSelectionFromStdIo();
    }

    protected int getModelSelection() throws IOException {
        AbstractGenerator.printToScreen("Which database model should be created:");
        AbstractGenerator.printToScreen("0 default");
        AbstractGenerator.printToScreen("1 sampling");
        AbstractGenerator.printToScreen("");
        AbstractGenerator.printEnterYourSelection();
        return this.readSelectionFromStdIo();
    }

    protected int getConceptSelection() throws IOException {
        AbstractGenerator.printToScreen("Which observation concept should be created:");
        AbstractGenerator.printToScreen("0   simple");
        AbstractGenerator.printToScreen("1   transactional");
        AbstractGenerator.printToScreen("2   ereporting");
        AbstractGenerator.printToScreen("3   proxy");
        AbstractGenerator.printToScreen("");
        AbstractGenerator.printEnterYourSelection();
        return this.readSelectionFromStdIo();
    }

    protected int getFeatureConceptSelection() throws IOException {
        AbstractGenerator.printToScreen("Which feature concept should be created:");
        AbstractGenerator.printToScreen("0   default");
        AbstractGenerator.printToScreen("1   extended");
        AbstractGenerator.printToScreen("");
        AbstractGenerator.printEnterYourSelection();
        return this.readSelectionFromStdIo();
    }

    protected void setDirectoriesForModelSelection(Concept concept, Profile profile, Feature feature, Configuration configuration, MetadataSources metadataSources) throws Exception {
        LinkedList files = new LinkedList();
        for (File file : files) {
            if (configuration != null) {
                configuration.addDirectory(file);
            }
            if (metadataSources == null) continue;
            metadataSources.addDirectory(file);
        }
        this.addConceptDirectories(concept, profile, feature, configuration, metadataSources);
    }

    protected void addConceptDirectories(Concept concept, Profile profile, Feature feature, Configuration configuration, MetadataSources metadataSources) throws Exception {
        LinkedList<String> paths = new LinkedList<String>();
        String parameterMappingDir = "/hbm/parameter";
        switch (concept) {
            case SIMPLE: {
                paths.addAll(this.getProfileDirectories("/hbm/simple", profile));
                break;
            }
            case E_REPORTING: {
                paths.addAll(this.getProfileDirectories("/hbm/ereporting", Profile.DEFAULT));
                paths.add("/hbm/parameter");
                paths.addAll(this.getFeatureConceptDirectories(feature, configuration, metadataSources));
                break;
            }
            case PROXY: {
                paths.addAll(this.getProfileDirectories("/hbm/proxy", profile));
                paths.add("/hbm/parameter");
                paths.addAll(this.getFeatureConceptDirectories(feature, configuration, metadataSources));
                break;
            }
            default: {
                paths.addAll(this.getProfileDirectories("/hbm/transactional", profile));
                paths.add("/hbm/parameter");
                paths.addAll(this.getFeatureConceptDirectories(feature, configuration, metadataSources));
            }
        }
        for (String path : paths) {
            if (configuration != null) {
                configuration.addDirectory(this.getDirectory(path));
            }
            if (metadataSources == null) continue;
            metadataSources.addDirectory(this.getDirectory(path));
        }
    }

    protected List<String> getFeatureConceptDirectories(Feature concept, Configuration configuration, MetadataSources metadataSources) throws Exception {
        LinkedList<String> paths = new LinkedList<String>();
        switch (concept) {
            case EXTENDED: {
                paths.add("/hbm/feature");
                break;
            }
        }
        return paths;
    }

    protected Collection<String> getProfileDirectories(String p, Profile profile) {
        LinkedList<String> paths = new LinkedList<String>();
        paths.add(p + "/core");
        switch (profile) {
            case DEFAULT: {
                paths.add(p + "/dataset");
                break;
            }
            case SAMPLING: {
                paths.add(p + "/sampling");
                break;
            }
        }
        return paths;
    }

    protected File getDirectory(String path) throws URISyntaxException {
        return new File(AbstractGenerator.class.getResource(path).toURI());
    }

    protected static void printToScreen(String lineToPrint) {
        System.out.println(lineToPrint);
    }

    protected static void printEnterYourSelection() {
        AbstractGenerator.printToScreen("Enter your selection: ");
    }

    protected void printToSysout(String lineToPrint) {
        if (this.print) {
            System.out.println(lineToPrint);
        }
    }

    protected int readSelectionFromStdIo() throws IOException {
        return this.readSelectionFromStdIoWithDefault(0);
    }

    protected int readSelectionFromStdIoWithDefault(int defaultValue) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
        String selection = br.readLine();
        return selection != null && !selection.isEmpty() ? Integer.parseInt(selection) : defaultValue;
    }

    protected String createFileName(String prefix, String ending, Enum ... values) {
        StringJoiner joiner = new StringJoiner("_", "target/" + prefix, ending);
        for (Enum value : values) {
            joiner.add(value.name().toLowerCase());
        }
        return joiner.toString();
    }

    public static class ColumnMetadata
    implements Meta {
        private final String name;
        private String comment;
        private String sqlType;
        private String type;
        private String defaultValue;
        private String notNull;

        public ColumnMetadata(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = this.check(this.comment, comment);
        }

        public String getSqlType() {
            return this.sqlType;
        }

        public void setSqlType(String sqlType) {
            this.sqlType = this.check(this.sqlType, sqlType);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = this.check(this.type, type);
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = this.check(this.defaultValue, defaultValue);
        }

        public String getNotNull() {
            return this.notNull;
        }

        public void setNotNull(String notNull) {
            this.notNull = this.check(this.notNull, notNull);
        }
    }

    public static class TableMetadata
    implements Meta {
        private final String name;
        private final String comment;
        private Map<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();

        public TableMetadata(String name, String comment) {
            this.name = name;
            this.comment = comment;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public Map<String, ColumnMetadata> getColumns() {
            return this.columns;
        }

        public void setColumns(Map<String, ColumnMetadata> columns) {
            this.columns = columns;
        }

        public String toMarkdown() {
            StringBuilder builder = new StringBuilder();
            builder.append("### ").append(this.getName()).append(AbstractGenerator.NEW_LINE);
            builder.append("**Description**: ").append(this.checkForNullOrEmpty(this.getComment())).append(AbstractGenerator.NEW_LINE);
            builder.append(AbstractGenerator.NEW_LINE);
            builder.append("| column | comment | NOT-NULL | default | SQL type | Java type |").append(AbstractGenerator.NEW_LINE);
            builder.append("| --- | --- | --- | --- | --- | --- |").append(AbstractGenerator.NEW_LINE);
            for (ColumnMetadata cm : this.columns.values()) {
                builder.append("| ").append(cm.getName()).append(AbstractGenerator.PIPE);
                builder.append(this.checkForNullOrEmpty(cm.getComment())).append(AbstractGenerator.PIPE);
                builder.append(cm.getNotNull()).append(AbstractGenerator.PIPE);
                builder.append(this.checkForNullOrEmpty(cm.getDefaultValue())).append(AbstractGenerator.PIPE);
                builder.append(cm.getSqlType()).append(AbstractGenerator.PIPE);
                builder.append(cm.getType()).append(AbstractGenerator.PIPE).append(AbstractGenerator.NEW_LINE);
            }
            builder.append("\n[top](#Tables)\n");
            return builder.toString();
        }

        private String checkForNullOrEmpty(String value) {
            return value != null && !value.isEmpty() ? value : "-";
        }
    }

    public static interface Meta {
        default public String check(String origin, String current) {
            return origin != null && !origin.isEmpty() ? origin : (current != null && !current.isEmpty() ? current : null);
        }
    }

    static enum Profile {
        DEFAULT,
        SAMPLING;


        public String toString() {
            return this.name().replaceAll("_", "-").toLowerCase();
        }
    }

    static enum Feature {
        DEFAULT,
        EXTENDED;


        public String toString() {
            return this.name().replaceAll("_", "-").toLowerCase();
        }
    }

    static enum Concept {
        SIMPLE,
        TRANSACTIONAL,
        E_REPORTING,
        PROXY;


        public String toString() {
            return this.name().replaceAll("_", "-").toLowerCase();
        }
    }

    static enum DialectSelector {
        POSTGIS,
        ORACLE,
        GEODB_H2,
        MYSQL,
        SQL_SERVER;


        public String toString() {
            return this.name().replaceAll("_", "-").toLowerCase();
        }
    }
}

