/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.generator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.n52.hibernate.type.SmallBooleanType;
import org.n52.series.db.generator.AbstractGenerator;

public final class TableMetadataGenerator
extends AbstractGenerator {
    private TableMetadataGenerator() {
    }

    private int getSelection() throws IOException {
        TableMetadataGenerator.printToScreen("Create a all or a single table metadata file:");
        TableMetadataGenerator.printToScreen("0   Select table metadata");
        TableMetadataGenerator.printToScreen("1   all");
        TableMetadataGenerator.printToScreen("");
        TableMetadataGenerator.printEnterYourSelection();
        return this.readSelectionFromStdIo();
    }

    private String createFileName(Enum ... values) {
        return this.createFileName("metadata/TableMetadata_", ".md", values);
    }

    private void exportTableColumnMetadata(Metadata metadata, Dialect dia, AbstractGenerator.DialectSelector dialect, AbstractGenerator.Concept concept, AbstractGenerator.Profile profile, AbstractGenerator.Feature feature) throws IOException {
        Path path = this.createFile(Paths.get(this.createFileName(dialect, concept, profile, feature), new String[0]));
        SortedMap<String, AbstractGenerator.TableMetadata> map = this.extractTableMetadata(metadata, dia);
        LinkedList<Object> result = new LinkedList<Object>();
        result.add("# Database table/column description");
        result.add("This page describes the tables and columns in the database.");
        result.add("The *SQL type* column in the tables is generated for Hibernate dialect: *" + dia.getClass().getSimpleName() + "*");
        result.add("");
        result.add("## Tables");
        map.keySet().forEach(k -> result.add("- [" + k + "](#" + k + ")"));
        result.add("");
        result.addAll(map.values().stream().map(v -> v.toMarkdown()).collect(Collectors.toList()));
        result.add("");
        result.add("*Creation date: " + DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss ZZ").print((ReadableInstant)DateTime.now()) + "*");
        System.out.println("The generated file was written to: " + Files.write(path, result, new OpenOption[0]).toAbsolutePath());
    }

    @SuppressFBWarnings
    private Path createFile(Path path) throws IOException {
        Files.deleteIfExists(path);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return Files.createFile(path, new FileAttribute[0]);
    }

    private SortedMap<String, AbstractGenerator.TableMetadata> extractTableMetadata(Metadata metadata, Dialect dia) {
        TreeMap<String, AbstractGenerator.TableMetadata> map = new TreeMap<String, AbstractGenerator.TableMetadata>();
        for (PersistentClass entity : metadata.getEntityBindings()) {
            Table table = entity.getTable();
            AbstractGenerator.TableMetadata tm = this.processTable(table, map, dia, metadata);
            this.processJoins(entity.getJoinClosureIterator(), map, dia, metadata);
            Iterator propertyIterator = entity.getPropertyIterator();
            while (propertyIterator.hasNext()) {
                Property property = (Property)propertyIterator.next();
                if (property.getValue() instanceof Collection) {
                    this.processCollection((Collection)property.getValue(), map, dia, metadata);
                }
                this.processColumns(property.getColumnIterator(), tm.getColumns(), dia, metadata);
            }
            this.processColumns(entity.getIdentifier().getColumnIterator(), tm.getColumns(), dia, metadata);
        }
        return map;
    }

    private void processJoins(Iterator<Join> ji, SortedMap<String, AbstractGenerator.TableMetadata> map, Dialect dia, Metadata metadata) {
        if (ji != null) {
            while (ji.hasNext()) {
                this.processTable(ji.next().getTable(), map, dia, metadata);
            }
        }
    }

    private void processCollection(Collection collection, SortedMap<String, AbstractGenerator.TableMetadata> map, Dialect dia, Metadata metadata) {
        Table table = collection.getCollectionTable();
        if (table != null) {
            if (!map.containsKey(table.getName())) {
                map.put(table.getName(), new AbstractGenerator.TableMetadata(table.getName(), table.getComment()));
            }
            AbstractGenerator.TableMetadata tm = (AbstractGenerator.TableMetadata)map.get(table.getName());
            Map<String, AbstractGenerator.ColumnMetadata> columns = tm.getColumns();
            this.processColumns(table.getColumnIterator(), columns, dia, metadata);
        }
    }

    private AbstractGenerator.TableMetadata processTable(Table table, SortedMap<String, AbstractGenerator.TableMetadata> map, Dialect dia, Metadata metadata) {
        if (!map.containsKey(table.getName())) {
            map.put(table.getName(), new AbstractGenerator.TableMetadata(table.getName(), table.getComment()));
        }
        AbstractGenerator.TableMetadata tm = (AbstractGenerator.TableMetadata)map.get(table.getName());
        Map<String, AbstractGenerator.ColumnMetadata> columns = tm.getColumns();
        this.processColumns(table.getColumnIterator(), columns, dia, metadata);
        return tm;
    }

    private void processColumns(Iterator<?> ci, Map<String, AbstractGenerator.ColumnMetadata> columns, Dialect dia, Metadata metadata) {
        while (ci.hasNext()) {
            Object n = ci.next();
            if (!(n instanceof Column)) continue;
            Column next = (Column)n;
            if (!columns.containsKey(next.getName())) {
                columns.put(next.getName(), new AbstractGenerator.ColumnMetadata(next.getName()));
            }
            AbstractGenerator.ColumnMetadata cm = columns.get(next.getName());
            cm.setComment(next.getComment());
            cm.setSqlType(next.getSqlType(dia, (Mapping)metadata));
            cm.setType(next.getValue().getType().getName());
            cm.setDefaultValue(next.getDefaultValue());
            cm.setNotNull(Boolean.toString(!next.isNullable()));
        }
    }

    private void execute(int dialectSelection, int profileSelection, int conceptSelection, int featureSelection) throws Exception {
        AbstractGenerator.Concept concept = AbstractGenerator.Concept.values()[conceptSelection];
        AbstractGenerator.Profile profile = AbstractGenerator.Profile.values()[profileSelection];
        AbstractGenerator.Feature feature = AbstractGenerator.Feature.values()[featureSelection];
        Configuration configuration = new Configuration().configure("/hibernate.cfg.xml");
        AbstractGenerator.DialectSelector dialect = AbstractGenerator.DialectSelector.values()[dialectSelection];
        Dialect dia = this.getDialect(dialect, true);
        Properties p = new Properties();
        p.put("hibernate.dialect", dia.getClass().getName());
        configuration.addProperties(p);
        this.setDirectoriesForModelSelection(concept, profile, feature, configuration, null);
        configuration.registerTypeOverride((BasicType)SmallBooleanType.INSTANCE);
        configuration.buildSessionFactory();
        StandardServiceRegistry serviceRegistry = configuration.getStandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        this.setDirectoriesForModelSelection(concept, profile, feature, null, metadataSources);
        Metadata metadata = metadataSources.buildMetadata();
        this.exportTableColumnMetadata(metadata, dia, dialect, concept, profile, feature);
    }

    protected boolean execute(Integer selection) throws Exception {
        int select;
        int n = select = selection != null ? selection.intValue() : this.getSelection();
        if (select == 1) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        for (int l = 0; l < 2; ++l) {
                            this.execute(i, j, k, l);
                        }
                    }
                }
            }
            return true;
        }
        int dialectSelection = this.getDialectSelection();
        int concept = this.getConceptSelection();
        int modelSelection = this.getModelSelection();
        int feature = this.getFeatureConceptSelection();
        this.execute(dialectSelection, modelSelection, concept, feature);
        return true;
    }

    protected static TableMetadataGenerator getInstance() {
        return new TableMetadataGenerator();
    }

    public static void main(String[] args) {
        try {
            TableMetadataGenerator.getInstance().execute(args != null && args.length == 1 ? Integer.valueOf(Integer.parseInt(args[0])) : null);
        }
        catch (IOException ioe) {
            TableMetadataGenerator.printToScreen("ERROR: IO error trying to read your input!");
            ioe.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            TableMetadataGenerator.printToScreen("ERROR: Could not generate for unknown reasons!");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

