/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.type.BasicType;
import org.n52.hibernate.type.SmallBooleanType;
import org.n52.series.db.generator.AbstractGenerator;

public final class SQLScriptGenerator
extends AbstractGenerator {
    private static final String PUBLIC = "public";

    private SQLScriptGenerator(boolean print) {
        super(print);
    }

    private int getSelection() throws IOException {
        SQLScriptGenerator.printToScreen("Create a all or a single selected script:");
        SQLScriptGenerator.printToScreen("0   Select script");
        SQLScriptGenerator.printToScreen("1   all");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printEnterYourSelection();
        return this.readSelectionFromStdIo();
    }

    private String getSchema() throws IOException {
        SQLScriptGenerator.printToScreen("For which schema should the database model be created?");
        SQLScriptGenerator.printToScreen("No schema is also valid!");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printEnterYourSelection();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
        String selection = null;
        selection = br.readLine();
        return selection;
    }

    private String getSchema(int i) {
        switch (i) {
            case 1: {
                return PUBLIC;
            }
            case 2: {
                return "oracle";
            }
            case 3: {
                return null;
            }
            case 4: {
                return "sos";
            }
            case 5: {
                return "dbo";
            }
        }
        return null;
    }

    private boolean getAddComments() throws IOException {
        SQLScriptGenerator.printToScreen("Should comments be added to the script (default=true):");
        SQLScriptGenerator.printToScreen("0   false");
        SQLScriptGenerator.printToScreen("1   true");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printEnterYourSelection();
        return this.readSelectionFromStdIoWithDefault(1) == 1;
    }

    private void printFinished(String fileName) {
        this.printToSysout("Finished! Check for file: " + fileName + "\n");
    }

    private String createFileName(String ending, Enum ... values) {
        return this.createFileName("sql/", ending, values);
    }

    private void execute(int dialectSelection, int profileSelection, int conceptSelection, int featureSelection, String schema, boolean comments, boolean consoleLog) throws Exception {
        AbstractGenerator.Concept concept = AbstractGenerator.Concept.values()[conceptSelection];
        AbstractGenerator.Profile profile = AbstractGenerator.Profile.values()[profileSelection];
        AbstractGenerator.Feature feature = AbstractGenerator.Feature.values()[featureSelection];
        Configuration configuration = new Configuration().configure("/hibernate.cfg.xml");
        AbstractGenerator.DialectSelector dialect = AbstractGenerator.DialectSelector.values()[dialectSelection];
        System.out.println(String.format("EXECUTING sql generation for %s - %s - %s - %s!", dialect.name(), concept.name(), profile.name(), feature.name()));
        Dialect dia = this.getDialect(dialect, comments);
        Properties p = new Properties();
        p.put("hibernate.dialect", dia.getClass().getName());
        String fileNameCreate = this.createFileName("_create.sql", dialect, concept, profile, feature);
        String fileNameDrop = this.createFileName("_drop.sql", dialect, concept, profile, feature);
        Files.deleteIfExists(Paths.get(fileNameCreate, new String[0]));
        Files.deleteIfExists(Paths.get(fileNameDrop, new String[0]));
        if (schema != null && !schema.isEmpty()) {
            p.put("hibernate.default_schema", schema);
        }
        configuration.addProperties(p);
        this.setDirectoriesForModelSelection(concept, profile, feature, configuration, null);
        configuration.registerTypeOverride((BasicType)SmallBooleanType.INSTANCE);
        configuration.buildSessionFactory();
        StandardServiceRegistry serviceRegistry = configuration.getStandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        this.setDirectoriesForModelSelection(concept, profile, feature, null, metadataSources);
        Metadata metadata = metadataSources.buildMetadata();
        SchemaExport schemaExport = new SchemaExport();
        EnumSet<TargetType> targetTypes = consoleLog ? EnumSet.of(TargetType.SCRIPT, TargetType.STDOUT) : EnumSet.of(TargetType.SCRIPT);
        schemaExport.setDelimiter(";").setFormat(true).setOutputFile(fileNameCreate).setHaltOnError(false);
        schemaExport.execute(targetTypes, SchemaExport.Action.CREATE, metadata);
        this.printFinished(fileNameCreate);
        schemaExport.setOutputFile(fileNameDrop);
        schemaExport.execute(targetTypes, SchemaExport.Action.DROP, metadata);
        this.printFinished(fileNameDrop);
    }

    protected boolean execute(Integer selection) throws Exception {
        int select;
        int n = select = selection != null ? selection.intValue() : this.getSelection();
        if (select == 1) {
            String schema = PUBLIC;
            for (int i = 0; i < 5; ++i) {
                schema = this.getSchema(i);
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        for (int l = 0; l < 2; ++l) {
                            this.execute(i, j, k, l, schema, true, false);
                        }
                    }
                }
            }
            return true;
        }
        boolean addComments = this.getAddComments();
        int dialectSelection = this.getDialectSelection();
        int concept = this.getConceptSelection();
        int feature = this.getFeatureConceptSelection();
        String schema = this.getSchema();
        int modelSelection = this.getModelSelection();
        this.execute(dialectSelection, modelSelection, concept, feature, schema, addComments, true);
        return true;
    }

    protected static SQLScriptGenerator getInstance(boolean print) {
        return new SQLScriptGenerator(print);
    }

    public static void main(String[] args) {
        try {
            SQLScriptGenerator.getInstance(true).execute(args != null && args.length == 1 ? Integer.valueOf(Integer.parseInt(args[0])) : null);
        }
        catch (IOException ioe) {
            SQLScriptGenerator.printToScreen("ERROR: IO error trying to read your input!");
            ioe.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            SQLScriptGenerator.printToScreen("ERROR: Could not generate for unknown reasons!");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

