/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.type.BasicType;
import org.n52.hibernate.type.SmallBooleanType;
import org.n52.series.db.generator.AbstractGenerator;

public class SQLScriptGenerator
extends AbstractGenerator {
    private SQLScriptGenerator() {
    }

    private int getSelection() throws IOException {
        SQLScriptGenerator.printToScreen("Create a all or a single selected script:");
        SQLScriptGenerator.printToScreen("0   Select script");
        SQLScriptGenerator.printToScreen("1   all");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printToScreen("Enter your selection: ");
        return this.readSelectionFromStdIo();
    }

    private int getDialectSelection() throws IOException {
        SQLScriptGenerator.printToScreen("This SQL script generator supports:");
        SQLScriptGenerator.printToScreen("0   PostgreSQL/PostGIS");
        SQLScriptGenerator.printToScreen("1   Oracle");
        SQLScriptGenerator.printToScreen("2   H2/GeoDB");
        SQLScriptGenerator.printToScreen("3   MySQL");
        SQLScriptGenerator.printToScreen("4   SQL Server");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printToScreen("Enter your selection: ");
        return this.readSelectionFromStdIo();
    }

    private int getModelSelection() throws IOException {
        SQLScriptGenerator.printToScreen("Which database model should be created:");
        SQLScriptGenerator.printToScreen("0 default");
        SQLScriptGenerator.printToScreen("1 sampling");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printToScreen("Enter your selection: ");
        return this.readSelectionFromStdIo();
    }

    private int getConceptSelection() throws IOException {
        SQLScriptGenerator.printToScreen("Which observation concept should be created:");
        SQLScriptGenerator.printToScreen("0   simple");
        SQLScriptGenerator.printToScreen("1   transactional");
        SQLScriptGenerator.printToScreen("2   ereporting");
        SQLScriptGenerator.printToScreen("3   proxy");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printToScreen("Enter your selection: ");
        return this.readSelectionFromStdIo();
    }

    private String getSchema() throws IOException {
        SQLScriptGenerator.printToScreen("For which schema should the database model be created?");
        SQLScriptGenerator.printToScreen("No schema is also valid!");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printToScreen("Enter your selection: ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
        String selection = null;
        selection = br.readLine();
        return selection;
    }

    public static void main(String[] args) {
        block12: {
            try {
                SQLScriptGenerator sqlScriptGenerator = new SQLScriptGenerator();
                int select = sqlScriptGenerator.getSelection();
                if (select == 1) {
                    String schema = "public";
                    for (int i = 0; i < 5; ++i) {
                        schema = sqlScriptGenerator.getSchema(i);
                        for (int j = 0; j < 2; ++j) {
                            for (int k = 0; k < 4; ++k) {
                                try {
                                    sqlScriptGenerator.execute(sqlScriptGenerator, i, j, k, schema, true, false);
                                    continue;
                                }
                                catch (Exception e) {
                                    SQLScriptGenerator.printToScreen("ERROR: " + e.getMessage());
                                    e.printStackTrace();
                                    System.exit(1);
                                }
                            }
                        }
                    }
                    break block12;
                }
                try {
                    boolean addComments = sqlScriptGenerator.getAddComments();
                    int dialectSelection = sqlScriptGenerator.getDialectSelection();
                    int concept = sqlScriptGenerator.getConceptSelection();
                    String schema = sqlScriptGenerator.getSchema();
                    int modelSelection = sqlScriptGenerator.getModelSelection();
                    sqlScriptGenerator.execute(sqlScriptGenerator, dialectSelection, modelSelection, concept, schema, addComments, true);
                }
                catch (IOException ioe) {
                    SQLScriptGenerator.printToScreen("ERROR: IO error trying to read your input!");
                    ioe.printStackTrace();
                    System.exit(1);
                }
                catch (Exception e) {
                    SQLScriptGenerator.printToScreen("ERROR: " + e.getMessage());
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            catch (IOException ioe) {
                SQLScriptGenerator.printToScreen("ERROR: IO error trying to read your input!");
                ioe.printStackTrace();
                System.exit(1);
            }
            catch (Exception e) {
                SQLScriptGenerator.printToScreen("ERROR: Could not generate for unknown reasons!");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private boolean getAddComments() throws IOException {
        SQLScriptGenerator.printToScreen("Should comments be added to the script (default=true):");
        SQLScriptGenerator.printToScreen("0   false");
        SQLScriptGenerator.printToScreen("1   true");
        SQLScriptGenerator.printToScreen("");
        SQLScriptGenerator.printToScreen("Enter your selection: ");
        return this.readSelectionFromStdIoWithDefault(1) == 1;
    }

    private String getSchema(int i) {
        switch (i) {
            case 1: {
                return "public";
            }
            case 2: {
                return "oracle";
            }
            case 3: {
                return null;
            }
            case 4: {
                return "sos";
            }
            case 5: {
                return "dbo";
            }
        }
        return null;
    }

    private void execute(SQLScriptGenerator sqlScriptGenerator, int dialectSelection, int profileSelection, int conceptSelection, String schema, boolean comments, boolean consoleLog) throws Exception {
        AbstractGenerator.Concept concept = AbstractGenerator.Concept.values()[conceptSelection];
        AbstractGenerator.Profile profile = AbstractGenerator.Profile.values()[profileSelection];
        Configuration configuration = new Configuration().configure("/hibernate.cfg.xml");
        AbstractGenerator.DialectSelector dialect = AbstractGenerator.DialectSelector.values()[dialectSelection];
        System.out.println(String.format("EXECUTING sql generation for %s - %s - %s!", dialect.name(), concept.name(), profile.name()));
        Dialect dia = sqlScriptGenerator.getDialect(dialect, comments);
        Properties p = new Properties();
        p.put("hibernate.dialect", dia.getClass().getName());
        String fileNameCreate = "target/" + (Object)((Object)dialect) + "_" + (Object)((Object)concept) + "_" + (Object)((Object)profile) + "_create.sql";
        String fileNameDrop = "target/" + (Object)((Object)dialect) + "_" + (Object)((Object)concept) + "_" + (Object)((Object)profile) + "_drop.sql";
        Files.deleteIfExists(Paths.get(fileNameCreate, new String[0]));
        Files.deleteIfExists(Paths.get(fileNameDrop, new String[0]));
        if (schema != null && !schema.isEmpty()) {
            p.put("hibernate.default_schema", schema);
        }
        configuration.addProperties(p);
        sqlScriptGenerator.setDirectoriesForModelSelection(concept, profile, configuration, null);
        configuration.registerTypeOverride((BasicType)SmallBooleanType.INSTANCE);
        configuration.buildSessionFactory();
        StandardServiceRegistry serviceRegistry = configuration.getStandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        sqlScriptGenerator.setDirectoriesForModelSelection(concept, profile, null, metadataSources);
        Metadata metadata = metadataSources.buildMetadata();
        SchemaExport schemaExport = new SchemaExport();
        EnumSet<TargetType> targetTypes = consoleLog ? EnumSet.of(TargetType.SCRIPT, TargetType.STDOUT) : EnumSet.of(TargetType.SCRIPT);
        schemaExport.setDelimiter(";").setFormat(true).setOutputFile(fileNameCreate).setHaltOnError(false);
        schemaExport.execute(targetTypes, SchemaExport.Action.CREATE, metadata);
        SQLScriptGenerator.printToScreen("Finished! Check for file: " + fileNameCreate + "\n");
        schemaExport.setOutputFile(fileNameDrop);
        schemaExport.execute(targetTypes, SchemaExport.Action.DROP, metadata);
        SQLScriptGenerator.printToScreen("Finished! Check for file: " + fileNameDrop + "\n");
    }
}

