/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.common;

import com.neovisionaries.i18n.LanguageAlpha3Code;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class LocaleHelper {
    private static final Map<String, Locale> CACHE = Collections.synchronizedMap(new HashMap());

    private LocaleHelper() {
    }

    public static Locale decode(String locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (locale.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        return LocaleHelper.decode(locale, null);
    }

    public static Locale decode(String locale, @Nullable Locale defaultLocale) {
        return Optional.ofNullable(locale).map(String::trim).filter(LocaleHelper.not(String::isEmpty)).map(l -> CACHE.computeIfAbsent((String)l, LocaleHelper::decode1)).orElse(defaultLocale);
    }

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static String encode(Locale input) {
        if (input == null) {
            return null;
        }
        String country = input.getCountry();
        String language = input.getLanguage();
        StringBuilder sb = new StringBuilder(language);
        if (!country.isEmpty()) {
            sb.append("-").append(country);
        }
        return sb.toString();
    }

    public static Set<Locale> getEquivalents(Locale locale) {
        LinkedHashSet<Locale> locales = new LinkedHashSet<Locale>();
        LanguageAlpha3Code byCode = LanguageAlpha3Code.getByCode((String)locale.getLanguage());
        if (byCode != null) {
            locales.add(byCode.getAlpha2().toLocale());
            locales.add(new Locale(byCode.getAlpha3B().name()));
            locales.add(new Locale(byCode.getAlpha3T().name()));
        }
        return locales;
    }

    public static Set<String> getEquivalents(String locale) {
        return LocaleHelper.getEquivalents(LocaleHelper.decode(locale)).stream().map(l -> LocaleHelper.encode(l)).collect(Collectors.toSet());
    }

    private static Locale decode1(String locale) {
        String strippedQualifiers = LocaleHelper.stripQualityFactorWeights(locale);
        String firstLanguage = LocaleHelper.getFirstLanguageCode(strippedQualifiers);
        String[] tokens = firstLanguage.split("[-_# ]");
        if (tokens.length > 3) {
            throw new IllegalArgumentException("Unparsable language parameter: " + locale);
        }
        String language = tokens.length > 0 ? tokens[0].toLowerCase() : "";
        String country = tokens.length > 1 ? tokens[1].toUpperCase() : "";
        String variant = tokens.length > 2 ? tokens[2] : "";
        return new Locale(language, country, variant);
    }

    private static String stripQualityFactorWeights(String locale) {
        int semicolonIndex = locale.indexOf(";");
        boolean hasQualityFactorWeights = semicolonIndex != -1;
        return hasQualityFactorWeights ? locale.substring(0, semicolonIndex) : locale;
    }

    private static String getFirstLanguageCode(String locale) {
        return locale.split(",")[0];
    }
}

