/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.util.ArrayList;
import java.util.Collection;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.NumericalDataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountDataEntity
extends DataEntity<Integer>
implements NumericalDataEntity<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountDataEntity.class);
    private static final long serialVersionUID = -8559375927338360585L;

    @Override
    public boolean isNoDataValue(Collection<String> noDataValues) {
        return this.getValue() == null ? false : this.containsValue(noDataValues, (Integer)this.getValue());
    }

    @Override
    public boolean checkNoDataValue(Collection<Integer> noDataValues) {
        return this.getValue() == null ? false : this.checkValue(noDataValues, (Integer)this.getValue());
    }

    private boolean checkValue(Collection<Integer> collection, Integer value) {
        if (collection == null) {
            return false;
        }
        for (Integer noDataValue : collection) {
            if (!noDataValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean containsValue(Collection<String> collection, Integer value) {
        if (collection == null) {
            return false;
        }
        return this.checkValue(this.convertToIntegers(collection), value);
    }

    private Collection<Integer> convertToIntegers(Collection<String> collection) {
        ArrayList<Integer> validatedValues = new ArrayList<Integer>();
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                validatedValues.add(Integer.parseInt(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Ignoring NO_DATA value {} (not an integer).", (Object)trimmed);
            }
        }
        return validatedValues;
    }
}

