/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.n52.series.db.beans.AbstractDatasetEntity;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.AssessmentTypeEntity;
import org.n52.series.db.beans.CodespaceEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.Describable;
import org.n52.series.db.beans.FormatEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.NetworkEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.ProcedureHistoryEntity;
import org.n52.series.db.beans.RelatedDataEntity;
import org.n52.series.db.beans.RelatedFeatureEntity;
import org.n52.series.db.beans.TagEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.beans.i18n.I18nEntity;
import org.n52.series.db.beans.parameter.ParameterEntity;
import org.n52.series.db.common.LocaleHelper;

public interface HibernateRelations {
    public static final String SRID = "srid";
    public static final String GEOMETRY_ENTITY = "geometryEntity";
    public static final String P = "parents";
    public static final String C = "children";

    public static interface HasNetwork {
        public static final String PROPERTY_NETWORK = "network";

        public NetworkEntity getNetwork();

        public HasNetwork setNetwork(NetworkEntity var1);

        default public boolean isSetNetwork() {
            return this.getNetwork() != null;
        }
    }

    public static interface HasAssessmentType {
        public static final String PROPERTY_ASSESSMENT_TYPE = "assessmentType";

        public AssessmentTypeEntity getAssessmentType();

        public HasAssessmentType setAssessmentType(AssessmentTypeEntity var1);

        default public boolean isSetAssessmentType() {
            return this.getAssessmentType() != null && this.getAssessmentType().isSetAssessmentType();
        }
    }

    public static interface HasVerticalFromTo {
        public BigDecimal getVerticalFrom();

        public void setVerticalFrom(BigDecimal var1);

        public BigDecimal getVerticalTo();

        public void setVerticalTo(BigDecimal var1);

        default public boolean isSetVerticalFromTo() {
            return this.isSetVerticalFrom() && this.isSetVerticalTo();
        }

        default public boolean isSetVerticalFrom() {
            return this.getVerticalFrom() != null;
        }

        default public boolean isSetVerticalTo() {
            return this.getVerticalTo() != null;
        }
    }

    public static interface HasObservations {
        public Set<DataEntity<?>> getObservations();

        public void setObservations(Set<DataEntity<?>> var1);

        default public boolean hasObservations() {
            return this.getObservations() != null;
        }
    }

    @Deprecated
    public static interface HasThing
    extends HasPlatform {
        default public PlatformEntity getThing() {
            return this.getPlatform();
        }

        default public void setThing(PlatformEntity thing) {
            this.setPlatform(thing);
        }

        default public boolean hasThing() {
            return this.hasPlatform();
        }
    }

    public static interface HasPlatform {
        public PlatformEntity getPlatform();

        public void setPlatform(PlatformEntity var1);

        default public boolean hasPlatform() {
            return this.getPlatform() != null;
        }
    }

    public static interface IsNoDataValue {
        public boolean isNoDataValue(Collection<String> var1);
    }

    public static interface IsProcessed {
        public boolean isProcessed();

        public void setProcessed(boolean var1);
    }

    public static interface HasTags {
        public static final String TAGS = "tags";
        public static final String PROPERTY_TAGS = "tags";

        public Set<TagEntity> getTags();

        public void setTags(Set<TagEntity> var1);

        default public boolean hasTags() {
            return this.getTags() != null && !this.getTags().isEmpty();
        }
    }

    public static interface HasDescriptionTranslation
    extends HasDescription,
    HasTranslations {
        default public String getDescriptionI18n(String locale) {
            if (this.noTranslationAvailable(locale)) {
                return this.getDescription();
            }
            I18nEntity<? extends Describable> translation = this.getTranslation(locale);
            return translation != null ? translation.getDescription() : this.getDescription();
        }
    }

    public static interface HasNameTranslation
    extends HasName,
    HasTranslations {
        default public boolean isi18nNameAvailable(String locale) {
            return this.getNameI18n(locale) != null && !this.getNameI18n(locale).isEmpty();
        }

        default public String getNameI18n(String locale) {
            if (this.noTranslationAvailable(locale)) {
                return this.getName();
            }
            I18nEntity<? extends Describable> translation = this.getTranslation(locale);
            return translation != null ? translation.getName() : this.getName();
        }
    }

    public static interface HasTranslations {
        public static final String TRANSLATIONS = "translations";
        public static final String PROPERTY_TRANSLATIONS = "translations";
        public static final String LOCALE_REGEX = "[-_# ]";

        public Set<I18nEntity<? extends Describable>> getTranslations();

        public void setTranslations(Set<I18nEntity<? extends Describable>> var1);

        default public boolean hasTranslations() {
            return this.getTranslations() != null && !this.getTranslations().isEmpty();
        }

        default public boolean noTranslationAvailable(String locale) {
            return this.getTranslations() == null || locale == null || this.getTranslations().isEmpty() || locale.isEmpty();
        }

        default public String getCountryCode(String locale) {
            if (locale != null) {
                return locale.split(LOCALE_REGEX).length > 1 ? locale.split(LOCALE_REGEX)[1] : locale.split(LOCALE_REGEX)[0];
            }
            return "";
        }

        default public I18nEntity<? extends Describable> getTranslation(String locale) {
            if (!this.noTranslationAvailable(locale)) {
                String countryCode = this.getCountryCode(locale);
                Locale matchingLocale = this.getMatchingLocale(this.getTranslations(), locale);
                for (I18nEntity<? extends Describable> translation : this.getTranslations()) {
                    Locale translatedLocale = LocaleHelper.decode(translation.getLocale());
                    if (!translatedLocale.equals(matchingLocale) && !translatedLocale.getCountry().equalsIgnoreCase(countryCode)) continue;
                    return translation;
                }
            }
            return null;
        }

        default public Locale getMatchingLocale(Set<I18nEntity<? extends Describable>> translations, String queriedLocale) {
            List<Locale.LanguageRange> localeRange = Locale.LanguageRange.parse(queriedLocale);
            return Locale.lookup(localeRange, translations.stream().map(t -> LocaleHelper.decode(t.getLocale())).collect(Collectors.toSet()));
        }
    }

    public static interface HasAbstractDataset {
        public AbstractDatasetEntity getDataset();

        public void setDataset(AbstractDatasetEntity var1);

        default public boolean hasDataset() {
            return this.getDataset() != null;
        }
    }

    public static interface HasAbstractDatasets {
        public Set<AbstractDatasetEntity> getDatasets();

        public void setDatasets(Set<AbstractDatasetEntity> var1);

        default public void addDatastream(AbstractDatasetEntity datastream) {
            if (this.getDatasets() == null) {
                this.setDatasets(new LinkedHashSet<AbstractDatasetEntity>());
            }
            this.getDatasets().add(datastream);
        }

        default public boolean hasDatastreams() {
            return this.hasDatasets();
        }

        default public boolean hasDatasets() {
            return this.getDatasets() != null && !this.getDatasets().isEmpty();
        }
    }

    public static interface HasDatasets {
        public static final String DATASETS = "datasets";
        public static final String PROPERTY_DATASETS = "datasets";

        public Set<DatasetEntity> getDatasets();

        public void setDatasets(Set<DatasetEntity> var1);

        default public boolean hasDatasets() {
            return this.getDatasets() != null && !this.getDatasets().isEmpty();
        }
    }

    public static interface HasDataset {
        public DatasetEntity getDataset();

        public void setDataset(DatasetEntity var1);

        default public boolean isSetDataset() {
            return this.getDataset() != null;
        }
    }

    public static interface HasDatasetType {
        public String getDatasetType();

        public void setDatasetType(String var1);

        default public boolean isSetDatasetType() {
            return this.getDatasetType() != null && !this.getDatasetType().isEmpty();
        }
    }

    public static interface HasRemarks {
        public String getRemarks();

        public void setRemarks(String var1);

        default public boolean isSetRemarks() {
            return this.getRemarks() != null && !this.getRemarks().isEmpty();
        }
    }

    public static interface HasXml {
        public static final String XML = "xml";

        public String getXml();

        public void setXml(String var1);

        default public boolean isSetXml() {
            return this.getXml() != null && !this.getXml().isEmpty();
        }
    }

    public static interface HasSamplingGeometry {
        public static final String SAMPLING_GEOMETRY = "geometryEntity";

        public Geometry getSamplingGeometry();

        public void setSamplingGeometry(Geometry var1);

        default public boolean hasSamplingGeometry() {
            return this.getSamplingGeometry() != null && !this.getSamplingGeometry().isEmpty();
        }
    }

    public static interface HasLocale {
        public static final String LOCALE = "locale";

        public Locale getLocale();

        public void setLocale(Locale var1);

        public boolean isSetLocale();
    }

    public static interface HasObservationId {
        public static final String OBS_ID = "id";

        public long getObservationId();

        public void setObservationId(long var1);
    }

    public static interface HasParentChildren<T> {
        public static final String PARENTS = "parents";
        public static final String CHILDREN = "children";

        public Set getParents();

        public void setParents(Set var1);

        public void addParent(T var1);

        default public boolean hasParents() {
            return this.getParents() != null && !this.getParents().isEmpty();
        }

        public Set getChildren();

        public void setChildren(Set var1);

        public void addChild(T var1);

        default public boolean hasChildren() {
            return this.getChildren() != null && !this.getChildren().isEmpty();
        }
    }

    public static interface HasProcedureHistory {
        public static final String VALID_PROCEDURE_TIMES = "procedureGistory";

        public Set<ProcedureHistoryEntity> getProcedureHistory();

        public void setProcedureHistory(Set<ProcedureHistoryEntity> var1);

        default public boolean hasProcedureHistory() {
            return this.getProcedureHistory() != null && !this.getProcedureHistory().isEmpty();
        }
    }

    public static interface HasCoordinate
    extends HasSrid {
        public static final String LONGITUDE = "longitude";
        public static final String LATITUDE = "latitude";
        public static final String ALTITUDE = "altitude";

        public Object getLon();

        public void setLon(Object var1);

        public Object getLat();

        public void setLat(Object var1);

        default public boolean isSetLongLat() {
            return this.getLon() != null && this.getLat() != null;
        }

        public Object getAlt();

        public void setAlt(Object var1);

        default public boolean isSetAlt() {
            return this.getAlt() != null;
        }

        public boolean isSpatial();
    }

    public static interface HasSrid {
        public static final String SRID = "srid";

        public int getSrid();

        public void setSrid(int var1);

        public boolean isSetSrid();
    }

    public static interface GeoColumnsId {
        public static final String COORD_DIMENSION = "coordDimension";
        public static final String SRID = "srid";
        public static final String TABLE_CATALOG = "FTableCatalog";
        public static final String TABLE_NAME = "FTableName";
        public static final String TABLE_SCHEMA = "FTableSchema";
        public static final String TYPE = "type";

        public Integer getCoordDimension();

        public void setCoordDimension(Integer var1);

        public String getFTableCatalog();

        public void setFTableCatalog(String var1);

        public String getFTableName();

        public void setFTableName(String var1);

        public String getFTableSchema();

        public void setFTableSchema(String var1);

        public Integer getSrid();

        public void setSrid(Integer var1);

        public String getType();

        public void setType(String var1);
    }

    public static interface HasObservableProperties {
        public static final String OBSERVABLE_PROPERTIES = "observableProperties";

        public Set<PhenomenonEntity> getObservableProperties();

        public void setObservableProperties(Set<PhenomenonEntity> var1);
    }

    public static interface HasRelatedObservations {
        public static final String RELATED_OBSERVATIONS = "related_observations";

        public Set<RelatedDataEntity> getRelatedObservations();

        public void setRelatedObservations(Set<RelatedDataEntity> var1);

        default public boolean hasRelatedObservations() {
            return this.getRelatedObservations() != null && !this.getRelatedObservations().isEmpty();
        }
    }

    public static interface HasParameters {
        public static final String PARAMETERS = "parameters";

        public Set<ParameterEntity<?>> getParameters();

        public void setParameters(Set<ParameterEntity<?>> var1);

        public void addParameters(Set<ParameterEntity<?>> var1);

        public void addParameter(ParameterEntity<?> var1);

        default public boolean hasParameters() {
            return this.getParameters() != null && !this.getParameters().isEmpty();
        }
    }

    public static interface HasOfferings {
        public static final String OFFERINGS = "offerings";

        public Set<OfferingEntity> getOfferings();

        public void setOfferings(Object var1);

        default public boolean isSetOfferings() {
            return this.hasOfferings();
        }

        default public boolean hasOfferings() {
            return this.getOfferings() != null && !this.getOfferings().isEmpty();
        }
    }

    public static interface HasUnitValue<T>
    extends HasUnit,
    HasValue<T> {
    }

    public static interface HasValue<T>
    extends GetStringValue {
        public static final String VALUE = "value";

        public T getValue();

        public void setValue(T var1);
    }

    public static interface GetStringValue {
        public boolean isSetValue();

        public String getValueAsString();
    }

    public static interface HasUrl {
        public static final String URL = "url";

        public String getUrl();

        public void setUrl(String var1);

        public boolean isSetUrl();
    }

    public static interface HasValidTime {
        public static final String VALID_TIME_START = "validTimeStart";
        public static final String VALID_TIME_END = "validTimeEnd";

        public Date getValidTimeStart();

        public void setValidTimeStart(Date var1);

        public Date getValidTimeEnd();

        public void setValidTimeEnd(Date var1);

        default public boolean isSetValidTime() {
            return this.isSetValidStartTime() && this.isSetValidEndTime();
        }

        default public boolean isSetValidStartTime() {
            return this.getValidTimeStart() != null;
        }

        default public boolean isSetValidEndTime() {
            return this.getValidTimeEnd() != null;
        }
    }

    public static interface HasUnit {
        public static final String UNIT = "unit";

        public UnitEntity getUnit();

        public void setUnit(UnitEntity var1);

        default public boolean isSetUnit() {
            return this.getUnit() != null;
        }
    }

    public static interface HasResultStructure {
        public static final String RESULT_STRUCTURE = "structure";

        public String getStructure();

        public void setStructure(String var1);

        default public boolean isSetStructure() {
            return this.getStructure() != null && !this.getStructure().isEmpty();
        }
    }

    public static interface HasResultEncoding {
        public static final String RESULT_ENCODING = "encoding";

        public String getEncoding();

        public void setEncoding(String var1);

        default public boolean isSetEncoding() {
            return this.getEncoding() != null && !this.getEncoding().isEmpty();
        }
    }

    public static interface HasRelatedFeatures {
        public static final String RELATED_FEATURES = "relatedFeatures";

        public Set<RelatedFeatureEntity> getRelatedFeatures();

        public void setRelatedFeatures(Set<RelatedFeatureEntity> var1);

        default public boolean hasRelatedFeatures() {
            return this.getRelatedFeatures() != null && !this.getRelatedFeatures().isEmpty();
        }
    }

    public static interface HasProcedureDescriptionFormat {
        public static final String PROCEDURE_DESCRIPTION_FORMAT = "format";

        public FormatEntity getFormat();

        public void setFormat(FormatEntity var1);
    }

    public static interface HasProcedure
    extends HasProcedureGetter {
        public void setProcedure(ProcedureEntity var1);

        default public boolean hasProcedure() {
            return this.getProcedure() != null;
        }
    }

    public static interface HasProcedureGetter {
        public static final String PROCEDURE = "procedure";

        public ProcedureEntity getProcedure();
    }

    public static interface HasResultTime {
        public static final String RESULT_TIME = "resultTime";

        public Date getResultTime();

        public void setResultTime(Date var1);

        default public boolean hasResultTime() {
            return this.getResultTime() != null;
        }
    }

    public static interface HasResultTimes {
        public static final String RESULT_TIME_START = "resultTimeStart";
        public static final String RESULT_TIME_END = "resultTimeEnd";

        public Date getResultTimeStart();

        public void setResultTimeStart(Date var1);

        default public boolean hasResultTimeStart() {
            return this.getResultTimeStart() != null;
        }

        public Date getResultTimeEnd();

        public void setResultTimeEnd(Date var1);

        default public boolean hasResultTimeEnd() {
            return this.getResultTimeEnd() != null;
        }
    }

    public static interface HasPhenomenonTime
    extends HasSamplingTime {
        @Deprecated
        default public Date getPhenomenonTimeStart() {
            return this.getSamplingTimeStart();
        }

        @Deprecated
        default public void setPhenomenonTimeStart(Date phenomenonTimeStart) {
            this.setSamplingTimeStart(phenomenonTimeStart);
        }

        @Deprecated
        default public boolean hasPhenomenonTimeStart() {
            return this.hasSamplingTimeStart();
        }

        @Deprecated
        default public Date getPhenomenonTimeEnd() {
            return this.getSamplingTimeEnd();
        }

        @Deprecated
        default public void setPhenomenonTimeEnd(Date phenomenonTimeEnd) {
            this.setSamplingTimeEnd(phenomenonTimeEnd);
        }

        @Deprecated
        default public boolean hasPhenomenonTimeEnd() {
            return this.hasSamplingTimeEnd();
        }
    }

    public static interface HasSamplingTime {
        public Date getSamplingTimeStart();

        public void setSamplingTimeStart(Date var1);

        public Date getSamplingTimeEnd();

        public void setSamplingTimeEnd(Date var1);

        default public boolean hasSamplingTimeStart() {
            return this.getSamplingTimeStart() != null;
        }

        default public boolean hasSamplingTimeEnd() {
            return this.getSamplingTimeStart() != null;
        }

        default public boolean isSamplingTimePeriod() {
            return this.hasSamplingTimeStart() && this.hasSamplingTimeEnd() && !this.getSamplingTimeStart().equals(this.getSamplingTimeEnd());
        }
    }

    public static interface HasOffering {
        public static final String OFFERING = "offering";

        public OfferingEntity getOffering();

        public void setOffering(OfferingEntity var1);

        public boolean isSetOffering();
    }

    public static interface HasObservationTypes {
        public static final String OBSERVATION_TYPES = "omObservationTypes";

        public Set<FormatEntity> getObservationTypes();

        public void setObservationTypes(Set<FormatEntity> var1);

        default public boolean hasObservationTypes() {
            return this.getObservationTypes() != null && !this.getObservationTypes().isEmpty();
        }
    }

    public static interface HasOMObservationType {
        public static final String OBSERVATION_TYPE = "omObservationType";

        public FormatEntity getOMObservationType();

        public void setOMObservationType(FormatEntity var1);

        public boolean isSetOMObservationType();
    }

    public static interface HasObservableProperty
    extends HasObservablePropertyGetter {
        public void setObservableProperty(PhenomenonEntity var1);

        default public boolean hasObservableProperty() {
            return this.getObservableProperty() != null;
        }
    }

    public static interface HasObservablePropertyGetter {
        public static final String OBSERVABLE_PROPERTY = "observableProperty";

        public PhenomenonEntity getObservableProperty();
    }

    @Deprecated
    public static interface HasObservation {
        public static final String OBSERVATION = "observation";

        public DataEntity<?> getObservation();

        public void setObservation(DataEntity<?> var1);
    }

    public static interface HasName {
        public static final String NAME = "name";
        public static final String PROPERTY_NAME = "name";

        public String getName();

        public void setName(String var1);

        default public boolean isSetName() {
            return this.getName() != null && !this.getName().isEmpty();
        }
    }

    public static interface HasParentFlag {
        public static final String PARENT = "parents";

        public boolean isParent();

        public void setParent(boolean var1);
    }

    public static interface HasChildFlag {
        public static final String CHILD = "children";

        public boolean isChild();

        public void setChild(boolean var1);
    }

    public static interface HasHiddenChildFlag {
        public static final String HIDDEN_CHILD = "hiddenChild";

        public boolean isHiddenChild();

        public void setHiddenChild(boolean var1);
    }

    public static interface HasGeometry {
        public static final String GEOMETRY = "geometryEntity";

        public GeometryEntity getGeometryEntity();

        public void setGeometryEntity(GeometryEntity var1);

        default public Geometry getGeometry() {
            return this.getGeometryEntity() != null ? this.getGeometryEntity().getGeometry() : null;
        }

        public void setGeometry(Geometry var1);

        default public boolean isSetGeometry() {
            return this.getGeometryEntity() != null && !this.getGeometryEntity().isEmpty();
        }
    }

    public static interface HasWriteableObservationContext
    extends HasReadableObservationContext,
    HasObservableProperty,
    HasProcedure,
    HasFeature,
    HasOffering {
    }

    public static interface HasReadableObservationContext
    extends HasObservablePropertyGetter,
    HasProcedureGetter,
    HasFeatureGetter {
    }

    public static interface HasFeature
    extends HasFeatureGetter {
        public void setFeature(AbstractFeatureEntity<?> var1);

        default public boolean hasFeature() {
            return this.getFeature() != null;
        }
    }

    public static interface HasFeatureGetter {
        public static final String FEATURE_OF_INTEREST = "feature";

        public AbstractFeatureEntity<?> getFeature();
    }

    public static interface HasFeatureTypes {
        public static final String FEATURE__TYPES = "featureTypes";

        public Set<FormatEntity> getFeatureTypes();

        public void setFeatureTypes(Set<FormatEntity> var1);

        default public boolean hasFeatureTypes() {
            return this.getFeatureTypes() != null && !this.getFeatureTypes().isEmpty();
        }
    }

    public static interface HasFeatureType {
        public static final String FEATURE_OF_INTEREST_TYPE = "featureType";

        public FormatEntity getFeatureType();

        public void setFeatureType(FormatEntity var1);
    }

    public static interface HasPublishedFlag {
        public static final String PUBLISHED = "published";

        public boolean isPublished();

        public HasPublishedFlag setPublished(boolean var1);
    }

    public static interface HasDeletedFlag {
        public static final String DELETED = "deleted";

        public boolean getDeleted();

        public boolean isDeleted();

        public void setDeleted(boolean var1);
    }

    public static interface HasDisabledFlag {
        public static final String DIABLED = "disabled";

        public boolean getDisabled();

        public boolean isDisabled();

        public void setDisabled(boolean var1);
    }

    public static interface HasNameCodespace {
        public static final String NAME_CODESPACE = "nameCodespace";
        public static final String PROPERTY_NAME_CODESPACE = "nameCodespace";
        public static final String PROPERTY_CODESPACE_NAME = "nameCodespace";

        public CodespaceEntity getNameCodespace();

        public void setNameCodespace(CodespaceEntity var1);

        default public boolean isSetNameCodespace() {
            return this.getNameCodespace() != null && !this.getNameCodespace().isSetName();
        }
    }

    public static interface HasIdentifierCodespace {
        public static final String IDENTIFIER_CODESPACE = "identifierCodespace";

        public CodespaceEntity getIdentifierCodespace();

        public void setIdentifierCodespace(CodespaceEntity var1);

        default public boolean isSetIdentifierCodespace() {
            return this.getIdentifierCodespace() != null && !this.getIdentifierCodespace().isSetName();
        }
    }

    public static interface HasDescription {
        public static final String DESCRIPTION = "description";
        public static final String PROPERTY_DESCRIPTION = "description";

        public String getDescription();

        public void setDescription(String var1);

        default public boolean isSetDescription() {
            return this.getDescription() != null && !this.getDescription().isEmpty();
        }
    }

    public static interface HasDomainId {
        public static final String IDENTIFIER = "identifier";

        public String getIdentifier();

        public void setIdentifier(String var1);

        public boolean isSetIdentifier();
    }

    public static interface IsStaEntity {
    }

    public static interface HasStaIdentifier
    extends HasIdentifier {
        public static final String STA_IDENTIFIER = "staIdentifier";

        public String getStaIdentifier();

        public void setStaIdentifier(String var1);

        default public boolean isSetStaIdentifier() {
            return this.getStaIdentifier() != null && !this.getStaIdentifier().isEmpty();
        }

        default public String generateUUID() {
            return UUID.randomUUID().toString();
        }

        default public String processIdentifierForSta(String identifier) {
            if (identifier == null || identifier.isEmpty()) {
                return this.generateUUID();
            }
            if (identifier.contains("/")) {
                try {
                    URI uri = URI.create(identifier.trim());
                    StringBuffer buffer = new StringBuffer("urn");
                    this.addValue(buffer, uri.getScheme());
                    this.addHost(buffer, uri.getHost());
                    this.addPort(buffer, uri.getPort());
                    this.addPath(buffer, uri.getPath());
                    this.addFragment(buffer, uri.getFragment());
                    return buffer.toString();
                }
                catch (Exception e) {
                    try {
                        return UUID.nameUUIDFromBytes(identifier.trim().getBytes("UTF8")).toString();
                    }
                    catch (UnsupportedEncodingException e1) {
                        return this.generateUUID();
                    }
                }
            }
            return identifier.trim();
        }

        default public void addValue(StringBuffer buffer, String value) {
            this.addValue(buffer, value, true);
        }

        default public void addValue(StringBuffer buffer, String value, boolean addEmpty) {
            if (value != null && (addEmpty && value.isEmpty() || !value.isEmpty())) {
                buffer.append(":").append(value);
            }
        }

        default public void addHost(StringBuffer buffer, String value) {
            if (value != null) {
                this.addValues(value, ".", buffer);
            }
        }

        default public void addPort(StringBuffer buffer, int value) {
            if (value >= 0) {
                this.addValue(buffer, Integer.toString(value));
            }
        }

        default public void addPath(StringBuffer buffer, String value) {
            if (value != null) {
                this.addValues(value, "/", buffer);
            }
        }

        default public void addFragment(StringBuffer buffer, String value) {
            if (value != null) {
                buffer.append("#").append(value);
            }
        }

        default public void addValues(String value, String splitChar, StringBuffer buffer) {
            if (!value.contains(splitChar)) {
                this.addValue(buffer, value);
            } else {
                Arrays.asList(value.split(Pattern.quote(splitChar))).stream().forEach(v -> this.addValue(buffer, (String)v, false));
            }
        }
    }

    public static interface HasIdentifier {
        public static final String IDENTIFIER = "identifier";

        public String getIdentifier();

        default public void setIdentifier(String identifier) {
            this.setIdentifier(identifier, false);
        }

        public void setIdentifier(String var1, boolean var2);

        default public boolean isSetIdentifier() {
            return this.getIdentifier() != null && !this.getIdentifier().isEmpty();
        }

        default public String getDomain() {
            return this.getIdentifier();
        }

        default public void setDomain(String domain) {
            this.setIdentifier(domain);
        }

        default public boolean isSetDomain() {
            return this.isSetIdentifier();
        }
    }

    public static interface HasId {
        public Long getId();

        public void setId(Long var1);
    }
}

