/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.IdentifierNameDescriptionEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.n52.series.db.beans.i18n.I18nEntity;
import org.n52.series.db.common.LocaleHelper;

public interface Describable<T>
extends IdentifierNameDescriptionEntity,
HibernateRelations.HasId,
HibernateRelations.HasParameters,
HibernateRelations.HasNameTranslation,
HibernateRelations.HasDescriptionTranslation {
    public ServiceEntity getService();

    public DescribableEntity setService(ServiceEntity var1);

    default public boolean hasService() {
        return this.getService() != null;
    }

    default public Set<Map<String, Object>> getMappedParameters(String locale) {
        return this.hasParameters() ? this.getParameters().stream().map(e -> e.toValueMap(locale)).collect(Collectors.toSet()) : null;
    }

    default public String getLabelFrom(String locale) {
        if (this.isi18nNameAvailable(locale)) {
            return this.getNameI18n(locale);
        }
        if (this.isSetName()) {
            return this.getName();
        }
        if (this.isSetIdentifier()) {
            return this.getIdentifier();
        }
        return Long.toString(this.getId());
    }

    default public boolean isNameAvailable() {
        return this.getName() != null && !this.getName().isEmpty();
    }

    default public boolean isDomainAvailable() {
        return this.getDomain() != null && !this.getDomain().isEmpty();
    }

    @Override
    default public boolean isi18nNameAvailable(String locale) {
        return this.getNameI18n(locale) != null && !this.getNameI18n(locale).isEmpty();
    }

    @Override
    default public boolean noTranslationAvailable(String locale) {
        return locale == null || locale.isEmpty() || this.getTranslations() == null || this.getTranslations().isEmpty();
    }

    @Override
    default public String getNameI18n(String locale) {
        if (this.noTranslationAvailable(locale)) {
            return this.getName();
        }
        I18nEntity<Describable> translation = this.getTranslation(locale);
        return translation != null ? translation.getName() : this.getName();
    }

    @Override
    default public String getDescriptionI18n(String locale) {
        if (this.noTranslationAvailable(locale)) {
            return this.getDescription();
        }
        I18nEntity<Describable> translation = this.getTranslation(locale);
        return translation != null ? translation.getDescription() : this.getDescription();
    }

    @Override
    default public String getCountryCode(String locale) {
        if (locale != null) {
            return locale.split("[-_# ]").length > 1 ? locale.split("[-_# ]")[1] : locale.split("[-_# ]")[0];
        }
        return "";
    }

    @Override
    default public I18nEntity<? extends Describable> getTranslation(String locale) {
        if (!this.noTranslationAvailable(locale)) {
            String countryCode = this.getCountryCode(locale);
            Locale matchingLocale = this.getMatchingLocale(this.getTranslations(), locale);
            for (I18nEntity<? extends Describable> translation : this.getTranslations()) {
                Locale translatedLocale = LocaleHelper.decode(translation.getLocale());
                if (!translatedLocale.equals(matchingLocale) && !translatedLocale.getCountry().equalsIgnoreCase(countryCode)) continue;
                return translation;
            }
        }
        return null;
    }

    @Override
    default public Locale getMatchingLocale(Set<I18nEntity<? extends Describable>> translations, String queriedLocale) {
        List<Locale.LanguageRange> localeRange = Locale.LanguageRange.parse(queriedLocale);
        return Locale.lookup(localeRange, translations.stream().map(t -> LocaleHelper.decode(t.getLocale())).collect(Collectors.toSet()));
    }
}

