/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.DetectionLimitEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.IdEntity;
import org.n52.series.db.beans.RelatedDataEntity;
import org.n52.series.db.beans.ereporting.EReportingProfileDataEntity;
import org.n52.series.db.beans.sampling.SamplingProfileDataEntity;
import org.n52.series.db.common.Utils;

public abstract class DataEntity<T>
extends DescribableEntity
implements Comparable<DataEntity<T>>,
Serializable,
HibernateRelations.HasPhenomenonTime,
HibernateRelations.IsStaEntity,
HibernateRelations.HasResultTime,
HibernateRelations.HasValidTime,
HibernateRelations.HasParameters,
HibernateRelations.HasDataset,
HibernateRelations.HasFeature,
HibernateRelations.IsProcessed,
HibernateRelations.IsNoDataValue {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_DATASET_ID = "datasetId";
    public static final String PROPERTY_RESULT_TIME = "resultTime";
    public static final String PROPERTY_SAMPLING_TIME_START = "samplingTimeStart";
    public static final String PROPERTY_SAMPLING_TIME_END = "samplingTimeEnd";
    public static final String PROPERTY_VALID_TIME_START = "valid_time_start";
    public static final String PROPERTY_VALID_TIME_END = "valid_time_end";
    public static final String PROPERTY_GEOMETRY_ENTITY = "geometryEntity";
    public static final String PROPERTY_GEOMETRY = "geometry";
    public static final String PROPERTY_DELETED = "deleted";
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_IDENTIFIER = "identifier";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_SAMPLING_PROFILE = "samplingProfile";
    public static final String PROPERTY_EREPORTING_PROFILE = "ereportingProfile";
    public static final String PROPERTY_VALUE_BOOLEAN = "valueBoolean";
    public static final String PROPERTY_VALUE_TEXT = "valueText";
    public static final String PROPERTY_VALUE_QUANTITY = "valueQuantity";
    public static final String PROPERTY_VALUE_CATEGORY = "valueCategory";
    public static final String PROPERTY_VALUE_COUNT = "valueCount";
    public static final BigDecimal NOT_SET_VERTICAL = BigDecimal.valueOf(0L);
    private static final long serialVersionUID = 273612846605300612L;
    private Date samplingTimeStart;
    private Date samplingTimeEnd;
    private T value;
    private GeometryEntity geometryEntity;
    private boolean deleted;
    private Date validTimeStart;
    private Date validTimeEnd;
    private Date resultTime;
    private Long parent;
    private DatasetEntity dataset;
    private Long datasetId;
    private Set<RelatedDataEntity> relatedObservations = new HashSet<RelatedDataEntity>(0);
    private String valueIdentifier;
    private String valueName;
    private String valueDescription;
    private BigDecimal verticalFrom = NOT_SET_VERTICAL;
    private BigDecimal verticalTo = NOT_SET_VERTICAL;
    private DetectionLimitEntity detectionLimit;
    private SamplingProfileDataEntity samplingProfile;
    private EReportingProfileDataEntity ereportingProfile;
    private Boolean valueBoolean;
    private String valueText;
    private BigDecimal valueQuantity;
    private String valueCategory;
    private Integer valueCount;
    private AbstractFeatureEntity<?> feature;
    private boolean processed;

    @Override
    public Date getSamplingTimeStart() {
        return Utils.createUnmutableTimestamp(this.samplingTimeStart);
    }

    @Override
    public void setSamplingTimeStart(Date samplingTimeStart) {
        this.samplingTimeStart = Utils.createUnmutableTimestamp(samplingTimeStart);
    }

    @Override
    public Date getSamplingTimeEnd() {
        return Utils.createUnmutableTimestamp(this.samplingTimeEnd);
    }

    @Override
    public void setSamplingTimeEnd(Date samplingTimeEnd) {
        this.samplingTimeEnd = Utils.createUnmutableTimestamp(samplingTimeEnd);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    public GeometryEntity getGeometryEntity() {
        return this.geometryEntity;
    }

    public void setGeometryEntity(GeometryEntity geometryEntity) {
        this.geometryEntity = geometryEntity;
    }

    public boolean isSetGeometryEntity() {
        return this.geometryEntity != null && !this.geometryEntity.isEmpty();
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public Date getValidTimeStart() {
        return Utils.createUnmutableTimestamp(this.validTimeStart);
    }

    @Override
    public void setValidTimeStart(Date validTimeStart) {
        this.validTimeStart = Utils.createUnmutableTimestamp(validTimeStart);
    }

    @Override
    public Date getValidTimeEnd() {
        return Utils.createUnmutableTimestamp(this.validTimeEnd);
    }

    @Override
    public void setValidTimeEnd(Date validTimeEnd) {
        this.validTimeEnd = Utils.createUnmutableTimestamp(validTimeEnd);
    }

    @Override
    public boolean isSetValidTime() {
        return this.isSetValidStartTime() && this.isSetValidEndTime();
    }

    @Override
    public boolean isSetValidStartTime() {
        return this.validTimeStart != null;
    }

    @Override
    public boolean isSetValidEndTime() {
        return this.validTimeEnd != null;
    }

    @Override
    public Date getResultTime() {
        return Utils.createUnmutableTimestamp(this.resultTime);
    }

    @Override
    public void setResultTime(Date resultTime) {
        this.resultTime = Utils.createUnmutableTimestamp(resultTime);
    }

    public Long getParent() {
        return this.parent;
    }

    public void setParent(Long parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    @Override
    public DatasetEntity getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(DatasetEntity dataset) {
        this.dataset = dataset;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Set<RelatedDataEntity> getRelatedObservations() {
        return this.relatedObservations;
    }

    public void setRelatedObservations(Set<RelatedDataEntity> relatedObservations) {
        this.relatedObservations = relatedObservations;
    }

    public boolean hasRelatedObservations() {
        return this.getRelatedObservations() != null && !this.getRelatedObservations().isEmpty();
    }

    public String getValueIdentifier() {
        return this.valueIdentifier;
    }

    public void setValueIdentifier(String valueIdentifier) {
        this.valueIdentifier = valueIdentifier;
    }

    public boolean hasValueIdentifier() {
        return this.getValueIdentifier() != null && !this.getValueIdentifier().isEmpty();
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public boolean hasValueName() {
        return this.getValueName() != null && !this.getValueName().isEmpty();
    }

    public String getValueDescription() {
        return this.valueDescription;
    }

    public void setValueDescription(String valueDescription) {
        this.valueDescription = valueDescription;
    }

    public boolean hasValueDescription() {
        return this.getValueDescription() != null && !this.getValueDescription().isEmpty();
    }

    public boolean hasVerticalInterval() {
        return this.hasVerticalFrom() && this.hasVerticalTo() && this.getVerticalFrom().compareTo(this.getVerticalTo()) != 0;
    }

    public BigDecimal getVerticalFrom() {
        return this.verticalFrom;
    }

    public void setVerticalFrom(BigDecimal verticalFrom) {
        this.verticalFrom = verticalFrom;
    }

    public boolean hasVerticalFrom() {
        return this.getVerticalFrom() != null;
    }

    public BigDecimal getVerticalTo() {
        return this.verticalTo;
    }

    public void setVerticalTo(BigDecimal verticalTo) {
        this.verticalTo = verticalTo;
    }

    public boolean hasVerticalTo() {
        return this.getVerticalTo() != null;
    }

    public DetectionLimitEntity getDetectionLimit() {
        return this.detectionLimit;
    }

    public void setDetectionLimit(DetectionLimitEntity detectionLimit) {
        this.detectionLimit = detectionLimit;
    }

    public boolean hasDetectionLimit() {
        return this.getDetectionLimit() != null;
    }

    public SamplingProfileDataEntity getSamplingProfile() {
        return this.samplingProfile;
    }

    public void setSamplingProfile(SamplingProfileDataEntity samplingProfile) {
        this.samplingProfile = samplingProfile;
    }

    public boolean hasSamplingProfile() {
        return this.getSamplingProfile() != null;
    }

    public EReportingProfileDataEntity getEreportingProfile() {
        return this.ereportingProfile;
    }

    public void setEreportingProfile(EReportingProfileDataEntity ereportingProfile) {
        this.ereportingProfile = ereportingProfile;
    }

    public boolean hasEreportingProfile() {
        return this.getEreportingProfile() != null;
    }

    public Boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public void setValueBoolean(Boolean valueBoolean) {
        this.valueBoolean = valueBoolean;
    }

    public String getValueText() {
        return this.valueText;
    }

    public void setValueText(String valueText) {
        this.valueText = valueText;
    }

    public BigDecimal getValueQuantity() {
        return this.valueQuantity;
    }

    public void setValueQuantity(BigDecimal valueQuantity) {
        this.valueQuantity = valueQuantity;
    }

    public String getValueCategory() {
        return this.valueCategory;
    }

    public void setValueCategory(String valueCategory) {
        this.valueCategory = valueCategory;
    }

    public Integer getValueCount() {
        return this.valueCount;
    }

    public void setValueCount(Integer valueCount) {
        this.valueCount = valueCount;
    }

    @Override
    public AbstractFeatureEntity<?> getFeature() {
        return this.feature;
    }

    @Override
    public void setFeature(AbstractFeatureEntity<?> feature) {
        this.feature = feature;
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    @Override
    public int compareTo(DataEntity<T> o) {
        return Comparator.comparing(DataEntity::getSamplingTimeEnd).thenComparing(DataEntity::getSamplingTimeStart).thenComparing(IdEntity::getId).compare(this, o);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" id: ").append(this.getId()).append(" ]").toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDataset(), this.getSamplingTimeStart(), this.getSamplingTimeEnd(), this.getResultTime(), this.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DataEntity)) {
            return false;
        }
        DataEntity other = (DataEntity)obj;
        return super.equals(obj) && Objects.equals(this.getDataset(), other.getDataset()) && Objects.equals(this.getSamplingTimeStart(), other.getSamplingTimeStart()) && Objects.equals(this.getSamplingTimeStart(), other.getSamplingTimeStart()) && Objects.equals(this.getSamplingTimeEnd(), other.getSamplingTimeEnd()) && Objects.equals(this.getResultTime(), other.getResultTime()) && Objects.equals(this.getValue(), other.getValue());
    }
}

