/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.io.Serializable;
import java.util.StringJoiner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryEntity
implements Serializable {
    public static final String PROPERTY_GEOMETRY = "geometry";
    public static final String PROPERTY_LAT = "lat";
    public static final String PROPERTY_LON = "lon";
    public static final String PROPERTY_ALT = "alt";
    public static final String PROPERTY_SRID = "srid";
    private static final long serialVersionUID = -1411829809704409439L;
    private GeometryFactory geometryFactory;
    private Geometry geometry;
    private Double lon;
    private Double lat;
    private Double alt;
    private int srid;

    public boolean isSetGeometry() {
        return this.geometry != null && !this.geometry.isEmpty();
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        Geometry builtGeometry = this.isSetLonLat() ? this.createPoint() : this.geometry;
        return builtGeometry;
    }

    private Geometry createPoint() {
        Coordinate coordinate = this.alt != null && !this.alt.isNaN() ? new Coordinate(this.lon.doubleValue(), this.lat.doubleValue(), this.alt.doubleValue()) : new Coordinate(this.lon.doubleValue(), this.lat.doubleValue());
        return this.getGeometryFactory().createPoint(coordinate);
    }

    public boolean isSetLonLat() {
        return this.lon != null && this.lat != null;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getAlt() {
        return this.alt;
    }

    public void setAlt(Double alt) {
        this.alt = alt;
    }

    public int getSrid() {
        return this.srid;
    }

    public GeometryEntity setSrid(int srid) {
        this.srid = srid;
        return this;
    }

    public boolean isEmpty() {
        return !this.isSetGeometry() && !this.isSetLonLat();
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public void union(GeometryEntity entity) {
        if (entity != null && entity.getGeometry() != null) {
            if (this.getGeometry() != null) {
                this.setGeometry(this.getGeometry().union(entity.getGeometry()));
            } else {
                this.setGeometry(entity.getGeometry());
                this.setSrid(entity.getSrid());
            }
        }
    }

    public GeometryEntity copy(GeometryEntity entity) {
        this.setGeometry(entity.getGeometry().copy());
        this.setGeometryFactory(entity.getGeometryFactory());
        this.setLon(entity.getLon());
        this.setLat(entity.getLat());
        this.setAlt(entity.getAlt());
        this.setSrid(entity.getSrid());
        return entity;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append(this.getClass().getSimpleName()).append(" [");
        return (this.isSetGeometry() ? this.appendGeometry(sb) : this.appendLatLong(sb)).append(" ]").toString();
    }

    private StringBuffer appendGeometry(StringBuffer sb) {
        StringJoiner s = new StringJoiner(";");
        for (Coordinate coordinate : this.getGeometry().getCoordinates()) {
            s.add(new StringBuffer().append(" x: ").append(coordinate.getX()).append(", y: ").append(coordinate.getY()));
        }
        return sb.append(s.toString());
    }

    private StringBuffer appendLatLong(StringBuffer sb) {
        return sb.append(" latitude: ").append(this.getLat()).append(", longitude: ").append(this.getLon());
    }
}

