/*
 * Copyright (C) 2015-2021 52°North Spatial Information Research GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.series.db.beans.parameter.location;

import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.parameter.ParameterEntity;
import org.n52.series.db.beans.sta.LocationEntity;

/**
 * @author <a href="mailto:j.speckamp@52north.org">Jan Speckamp</a>
 */
public abstract class LocationParameterEntity<T> extends ParameterEntity<T> {

    public static final String PROP_LOCATION = "location";
    public static final String PROP_LOCATION_ID = "locationId";
    private static final long serialVersionUID = 8449960591522592006L;
    private LocationEntity location;
    private long locationId;

    public LocationEntity getLocation() {
        return location;
    }

    public void setLocation(LocationEntity location) {
        this.location = location;
    }

    public long getLocationId() {
        return locationId;
    }

    public void setLocationId(long observationId) {
        this.locationId = observationId;
    }

    @Override
    public void setDescribeableEntity(DescribableEntity entity) {
        setLocation((LocationEntity) entity);
    }
}
