/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.n52.series.db.beans.GeometryEntity;

public class GeometryEntityTest {
    @Test
    public void geometryToString() throws ParseException {
        GeometryEntity geometryEntity = new GeometryEntity();
        geometryEntity.setGeometry(new WKTReader(new GeometryFactory()).read("Point(52.7 7.52)"));
        Assertions.assertEquals((Object)"GeometryEntity [ x: 52.7, y: 7.52 ]", (Object)geometryEntity.toString());
    }

    @Test
    public void latLonToString() {
        GeometryEntity geometryEntity = new GeometryEntity();
        geometryEntity.setLat(Double.valueOf(52.7));
        geometryEntity.setLon(Double.valueOf(7.52));
        Assertions.assertEquals((Object)"GeometryEntity [ latitude: 52.7, longitude: 7.52 ]", (Object)geometryEntity.toString());
    }

    @Test
    public void copy() throws ParseException {
        GeometryEntity geometryEntity = new GeometryEntity();
        geometryEntity.setGeometry(new WKTReader(new GeometryFactory()).read("Point(52.7 7.52)"));
        GeometryEntity copy = geometryEntity.copy();
        Assertions.assertEquals((int)geometryEntity.hashCode(), (int)geometryEntity.hashCode());
        Assertions.assertEquals((int)copy.hashCode(), (int)copy.hashCode());
        Assertions.assertNotEquals((int)geometryEntity.hashCode(), (int)copy.hashCode());
    }
}

