/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans.sta;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FormatEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.sta.HistoricalLocationEntity;
import org.n52.series.db.beans.sta.StaRelations;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class LocationEntity
extends DescribableEntity
implements Serializable,
HibernateRelations.HasGeometry,
HibernateRelations.HasName,
HibernateRelations.HasDescription,
HibernateRelations.IsProcessed,
StaRelations.HasPlatforms<LocationEntity>,
StaRelations.HasHistoricalLocations<LocationEntity> {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_GEOMETRY_ENTITY = "geometryEntity";
    public static final String PROPERTY_LOCATION_ENCODING = "locationEncoding";
    private static final long serialVersionUID = -8201429072560300649L;
    private String location;
    private GeometryEntity geometryEntity;
    private FormatEntity locationEncoding;
    private Set<PlatformEntity> platforms;
    private Set<HistoricalLocationEntity> historicalLocations;
    private boolean processed;

    public FormatEntity getLocationEncoding() {
        return this.locationEncoding;
    }

    public LocationEntity setLocationEncoding(FormatEntity locationEncoding) {
        this.locationEncoding = locationEncoding;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public LocationEntity setLocation(String location) {
        this.location = location;
        return this;
    }

    public boolean hasLocation() {
        return this.getLocation() != null && !this.getLocation().isEmpty();
    }

    @Override
    public GeometryEntity getGeometryEntity() {
        return this.geometryEntity;
    }

    @Override
    public void setGeometry(Geometry geometry) {
        this.geometryEntity = new GeometryEntity();
        this.geometryEntity.setGeometry(geometry);
        this.geometryEntity.setSrid(geometry.getSRID());
    }

    @Override
    public void setGeometryEntity(GeometryEntity geometryEntity) {
        this.geometryEntity = geometryEntity;
    }

    @Override
    public Set<PlatformEntity> getPlatforms() {
        return this.platforms;
    }

    @Override
    public LocationEntity setPlatforms(Set<PlatformEntity> platformEntities) {
        this.platforms = platformEntities;
        return this;
    }

    @Override
    public boolean hasPlatforms() {
        return this.getPlatforms() != null && !this.getPlatforms().isEmpty();
    }

    @Deprecated
    public Set<PlatformEntity> getThings() {
        return this.getPlatforms();
    }

    @Deprecated
    public LocationEntity setThings(Set<PlatformEntity> platformEntities) {
        return this.setPlatforms((Set)platformEntities);
    }

    @Deprecated
    public boolean hasThings() {
        return this.hasPlatforms();
    }

    @Override
    public Set<HistoricalLocationEntity> getHistoricalLocations() {
        return this.historicalLocations;
    }

    @Override
    public LocationEntity setHistoricalLocations(Set<HistoricalLocationEntity> historicalLocationEntities) {
        this.historicalLocations = historicalLocationEntities;
        return this;
    }

    @Override
    public LocationEntity addHistoricalLocation(HistoricalLocationEntity historicalLocationEntity) {
        if (this.historicalLocations == null) {
            this.historicalLocations = new LinkedHashSet<HistoricalLocationEntity>();
        }
        this.historicalLocations.add(historicalLocationEntity);
        return this;
    }

    @Override
    public boolean hasHistoricalLocations() {
        return this.getHistoricalLocations() != null && !this.getHistoricalLocations().isEmpty();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocationEntity)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public void setProcessed(boolean processsed) {
        this.processed = processsed;
    }
}

