/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.n52.series.db.beans.DescribableEntity;

public class DescribableEntityTest {
    private DescribableEntity entity = new DescribableEntity(){
        private static final long serialVersionUID = 2075113368317218591L;
    };

    @Test
    public void test_urn_mailto() {
        String processIdentifierForSta = this.entity.processIdentifierForSta("mailto:java-net@java.sun.com");
        Assertions.assertEquals((Object)"mailto:java-net@java.sun.com", (Object)processIdentifierForSta);
    }

    @Test
    public void test_urn_news() {
        String processIdentifierForSta = this.entity.processIdentifierForSta("news:comp.lang.java");
        Assertions.assertEquals((Object)"news:comp.lang.java", (Object)processIdentifierForSta);
    }

    @Test
    public void test_urn_isbn() {
        String processIdentifierForSta = this.entity.processIdentifierForSta("urn:isbn:096139210x");
        Assertions.assertEquals((Object)"urn:isbn:096139210x", (Object)processIdentifierForSta);
    }

    @Test
    public void test_url_http() {
        String processIdentifierForSta = this.entity.processIdentifierForSta("http://java.sun.com/j2se/1.3/");
        Assertions.assertEquals((Object)"urn:http:java:sun:com:j2se:1.3", (Object)processIdentifierForSta);
    }

    @Test
    public void test_url_docs() {
        String processIdentifierForSta = this.entity.processIdentifierForSta("docs/guide/collections/designfaq.html#28");
        Assertions.assertEquals((Object)"urn:docs:guide:collections:designfaq.html#28", (Object)processIdentifierForSta);
    }

    @Test
    public void test_url_file() {
        String processIdentifierForSta = this.entity.processIdentifierForSta("file:///~/calendar");
        Assertions.assertEquals((Object)"urn:file:~:calendar", (Object)processIdentifierForSta);
    }

    @Test
    public void test_id() {
        String processIdentifierForSta = this.entity.processIdentifierForSta("123");
        Assertions.assertEquals((Object)"123", (Object)processIdentifierForSta);
    }
}

