/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans.sampling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import java.util.Set;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.sampling.MeasuringProgramEntity;
import org.n52.series.db.common.Utils;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class SamplingEntity
extends DescribableEntity
implements HibernateRelations.HasDatasets,
HibernateRelations.HasSamplingTime {
    public static final String PROPERTY_DATASETS = "datasets";
    public static final String PROPERTY_OBSERVATIONS = "observations";
    public static final String PROPERTY_MEASURING_PROGRAM = "measuringProgram";
    public static final String PROPERTY_SAMPLING_TIME_START = "samplingTimeStart";
    public static final String PROPERTY_SAMPLING_TIME_END = "samplingTimeEnd";
    private static final long serialVersionUID = -8840602794587590180L;
    private Set<DatasetEntity> datasets;
    private MeasuringProgramEntity measuringProgram;
    private String sampler;
    private String samplingMethod;
    private String environmentalConditions;
    private Date samplingTimeStart;
    private Date samplingTimeEnd;
    private Set<DataEntity<?>> observations;

    public MeasuringProgramEntity getMeasuringProgram() {
        return this.measuringProgram;
    }

    public void setMeasuringProgram(MeasuringProgramEntity measuringProgram) {
        this.measuringProgram = measuringProgram;
    }

    public String getSampler() {
        return this.sampler;
    }

    public void setSampler(String sampler) {
        this.sampler = sampler;
    }

    public boolean isSetSampler() {
        return this.getSampler() != null;
    }

    public String getSamplingMethod() {
        return this.samplingMethod;
    }

    public void setSamplingMethod(String samplingMethod) {
        this.samplingMethod = samplingMethod;
    }

    public boolean isSetSamplingMethod() {
        return this.getSamplingMethod() != null && !this.getSamplingMethod().isEmpty();
    }

    public String getEnvironmentalConditions() {
        return this.environmentalConditions;
    }

    public void setEnvironmentalConditions(String environmentalConditions) {
        this.environmentalConditions = environmentalConditions;
    }

    public boolean isSetEnvironmentalConditions() {
        return this.getEnvironmentalConditions() != null && !this.getEnvironmentalConditions().isEmpty();
    }

    @Override
    public Date getSamplingTimeStart() {
        return Utils.createUnmutableTimestamp(this.samplingTimeStart);
    }

    @Override
    public void setSamplingTimeStart(Date samplingTimeStart) {
        this.samplingTimeStart = Utils.createUnmutableTimestamp(samplingTimeStart);
    }

    @Override
    public Date getSamplingTimeEnd() {
        return Utils.createUnmutableTimestamp(this.samplingTimeEnd);
    }

    @Override
    public void setSamplingTimeEnd(Date samplingTimeEnd) {
        this.samplingTimeEnd = Utils.createUnmutableTimestamp(samplingTimeEnd);
    }

    @Override
    public void setDatasets(Set<DatasetEntity> datasets) {
        this.datasets = datasets;
    }

    @Override
    public Set<DatasetEntity> getDatasets() {
        return this.datasets;
    }

    @Override
    public boolean hasDatasets() {
        return HibernateRelations.HasDatasets.super.hasDatasets() && !this.getDatasets().isEmpty();
    }

    public void setObservations(Set<DataEntity<?>> observations) {
        this.observations = observations;
    }

    public Set<DataEntity<?>> getObservations() {
        return this.observations;
    }

    public boolean hasObservations() {
        return this.getObservations() != null && !this.getObservations().isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

