/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.ServiceMetadataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEntity
extends DescribableEntity {
    private static final long serialVersionUID = 8926184900932191238L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceEntity.class);
    private String url;
    private String type = "RESTful series data access layer.";
    private List<String> noDataValues = new LinkedList<String>();
    private String version;
    private boolean supportsFirstLast = true;
    private String connector;
    private ServiceMetadataEntity serviceMetadata;
    private Set<BigDecimal> quantityNoDataValues = new LinkedHashSet<BigDecimal>();
    private Set<Integer> countNoDataValues = new LinkedHashSet<Integer>();

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNoDataValue(DataEntity<?> observation) {
        return observation == null || !observation.hasDetectionLimit() && this.checkNoDataValue(observation);
    }

    public String getNoDataValues() {
        return String.join((CharSequence)",", this.noDataValues);
    }

    public void setNoDataValues(String noDataValues) {
        LOGGER.debug("Set noData values: {}", (Object)noDataValues);
        this.noDataValues.clear();
        this.quantityNoDataValues.clear();
        this.countNoDataValues.clear();
        if (noDataValues != null && !noDataValues.isEmpty()) {
            String[] values = noDataValues.split(",");
            this.noDataValues.addAll(Arrays.asList(values));
            this.convertToBigDecimal(this.noDataValues);
            this.convertToIntegers(this.noDataValues);
        }
    }

    public void setNoDataValues(Collection<String> noDataValuesList, Collection<BigDecimal> quantityNoDataValues, Collection<Integer> countNoDataValues) {
        this.noDataValues.clear();
        this.quantityNoDataValues.clear();
        this.countNoDataValues.clear();
        this.noDataValues.addAll(noDataValuesList);
        this.quantityNoDataValues.addAll(quantityNoDataValues);
        this.countNoDataValues.addAll(countNoDataValues);
    }

    public boolean getSupportsFirstLast() {
        return this.supportsFirstLast;
    }

    public void setSupportsFirstLast(boolean supportsFirstLast) {
        this.supportsFirstLast = supportsFirstLast;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getConnector() {
        return this.connector;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public ServiceMetadataEntity getServiceMetadata() {
        return this.serviceMetadata;
    }

    public void setServiceMetadata(ServiceMetadataEntity serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    public boolean isSetServiceMetadata() {
        return this.getServiceMetadata() != null && this.getServiceMetadata().isSetMetadata();
    }

    private boolean checkNoDataValue(DataEntity<?> observation) {
        if (observation instanceof QuantityDataEntity) {
            return ((QuantityDataEntity)observation).checkNoDataValue((Collection<BigDecimal>)this.quantityNoDataValues);
        }
        if (observation instanceof CountDataEntity) {
            return ((CountDataEntity)observation).checkNoDataValue((Collection<Integer>)this.countNoDataValues);
        }
        return observation.isNoDataValue(this.noDataValues);
    }

    private void convertToBigDecimal(Collection<String> collection) {
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                this.quantityNoDataValues.add(new BigDecimal(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Ignoring NO_DATA value {} (not a big decimal value).", (Object)trimmed);
            }
        }
    }

    private void convertToIntegers(Collection<String> collection) {
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                this.countNoDataValues.add(Integer.parseInt(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Ignoring NO_DATA value {} (not an integer).", (Object)trimmed);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" url: ").append(this.getUrl()).append(", type: ").append(this.getType()).append(", version: ").append(this.getVersion()).append(", noDataValues: ").append(this.getNoDataValues()).append(" ]").toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServiceEntity)) {
            return false;
        }
        return super.equals(obj);
    }
}

