/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.StringJoiner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class GeometryEntity
implements Serializable {
    public static final String PROPERTY_GEOMETRY = "geometry";
    public static final String PROPERTY_LAT = "lat";
    public static final String PROPERTY_LON = "lon";
    public static final String PROPERTY_ALT = "alt";
    public static final String PROPERTY_SRID = "srid";
    private static final long serialVersionUID = -1411829809704409439L;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private Geometry geometry;
    private Double lon;
    private Double lat;
    private Double alt;
    private int srid;

    public boolean isSetGeometry() {
        return this.geometry != null && !this.geometry.isEmpty();
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        Geometry builtGeometry = this.isSetLonLat() ? this.createPoint() : this.geometry;
        return builtGeometry;
    }

    private Geometry createPoint() {
        Coordinate coordinate = this.alt != null && !this.alt.isNaN() ? new Coordinate(this.lon.doubleValue(), this.lat.doubleValue(), this.alt.doubleValue()) : new Coordinate(this.lon.doubleValue(), this.lat.doubleValue());
        return this.getGeometryFactory().createPoint(coordinate);
    }

    public boolean isSetLonLat() {
        return this.lon != null && this.lat != null;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getAlt() {
        return this.alt;
    }

    public void setAlt(Double alt) {
        this.alt = alt;
    }

    public int getSrid() {
        return this.srid;
    }

    public GeometryEntity setSrid(int srid) {
        this.srid = srid;
        return this;
    }

    public boolean isEmpty() {
        return !this.isSetGeometry() && !this.isSetLonLat();
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public void union(GeometryEntity entity) {
        if (entity != null && entity.getGeometry() != null) {
            if (this.getGeometry() != null) {
                this.setGeometry(this.getGeometry().union(entity.getGeometry()));
            } else {
                this.setGeometry(entity.getGeometry());
                this.setSrid(entity.getSrid());
            }
        }
    }

    public void expand(GeometryEntity entity) {
        if (entity != null && entity.getGeometry() != null) {
            if (this.getGeometry() != null) {
                Envelope envelope = this.getGeometry().getEnvelopeInternal();
                envelope.expandToInclude(entity.getGeometry().getEnvelopeInternal());
                this.setGeometry((Geometry)this.toPolygon(envelope, this.getGeometry().getSRID()));
            } else {
                this.setGeometry((Geometry)this.toPolygon(entity.getGeometry().getEnvelopeInternal(), entity.getGeometry().getSRID()));
                this.setSrid(entity.getSrid());
            }
        }
    }

    private Polygon toPolygon(Envelope env, int srid) {
        Coordinate[] coords = this.toCoordiates(env);
        Polygon polygon = this.getGeometryFactory().createPolygon(this.getGeometryFactory().createLinearRing(coords), null);
        polygon.setSRID(srid);
        return polygon;
    }

    private Coordinate[] toCoordiates(Envelope env) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
        return coords;
    }

    public GeometryEntity copy() {
        GeometryEntity copy = new GeometryEntity();
        copy.setGeometry(this.getGeometry().copy());
        copy.setGeometryFactory(this.getGeometryFactory());
        copy.setLon(this.getLon());
        copy.setLat(this.getLat());
        copy.setAlt(this.getAlt());
        copy.setSrid(this.getSrid());
        return copy;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append(this.getClass().getSimpleName()).append(" [");
        return (this.isSetGeometry() ? this.appendGeometry(sb) : this.appendLatLong(sb)).append(" ]").toString();
    }

    private StringBuffer appendGeometry(StringBuffer sb) {
        StringJoiner s = new StringJoiner(";");
        for (Coordinate coordinate : this.getGeometry().getCoordinates()) {
            s.add(new StringBuffer().append(" x: ").append(coordinate.getX()).append(", y: ").append(coordinate.getY()));
        }
        return sb.append(s.toString());
    }

    private StringBuffer appendLatLong(StringBuffer sb) {
        return sb.append(" latitude: ").append(this.getLat()).append(", longitude: ").append(this.getLon());
    }
}

