/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;
import org.n52.series.db.beans.AbstractDatasetEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.RelatedDatasetEntity;
import org.n52.series.db.beans.TagEntity;
import org.n52.series.db.beans.VerticalMetadataEntity;
import org.n52.series.db.beans.dataset.DatasetType;
import org.n52.series.db.beans.dataset.ObservationType;
import org.n52.series.db.beans.dataset.ValueType;
import org.n52.series.db.beans.sampling.SamplingProfileDatasetEntity;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class DatasetEntity
extends AbstractDatasetEntity
implements HibernateRelations.HasTags {
    public static final String ENTITY_ALIAS = "dataset";
    public static final String PROPERTY_DATASET_TYPE = "datasetType";
    public static final String PROPERTY_OBSERVATION_TYPE = "observationType";
    public static final String PROPERTY_VALUE_TYPE = "valueType";
    public static final String PROPERTY_PUBLISHED = "published";
    public static final String PROPERTY_DELETED = "deleted";
    public static final String PROPERTY_DISABLED = "disabled";
    public static final String HIDDEN_CHILD = "hidden";
    public static final String PROPERTY_MOBILE = "mobile";
    public static final String PROPERTY_INSITU = "insitu";
    public static final String PROPERTY_SAMPLING_PROFILE = "samplingProfile";
    public static final String PROPERTY_EREPORTING_PROFILE = "ereportingProfile";
    private static final String OFFSET_REGEX = "([+-](?:2[0-3]|[01][0-9]):[0-5][0-9])";
    private static final long serialVersionUID = -7491530543976690237L;
    private boolean published = true;
    private boolean deleted;
    private boolean disabled;
    private DatasetType datasetType;
    private ObservationType observationType;
    private ValueType valueType;
    private long observationCount = -1L;
    private boolean hidden;
    private boolean mobile;
    private boolean insitu = true;
    private String originTimezone;
    private DateTimeZone timeZone;
    private Set<RelatedDatasetEntity> relatedDatasets;
    private List<DatasetEntity> referenceValues;
    private Integer numberOfDecimals;
    private VerticalMetadataEntity verticalMetadata;
    private SamplingProfileDatasetEntity samplingProfile;
    private boolean ereportingProfile;
    private Set<TagEntity> tags;

    public DatasetEntity() {
        this(DatasetType.not_initialized, ObservationType.not_initialized, ValueType.not_initialized);
    }

    public DatasetEntity(String datasetType, String observationType, String valueType) {
        this(DatasetType.valueOf(datasetType), ObservationType.valueOf(observationType), ValueType.valueOf(valueType));
    }

    public DatasetEntity(DatasetType datasetType, ObservationType observationType, ValueType valueType) {
        this.datasetType = datasetType;
        this.observationType = observationType;
        this.valueType = valueType;
    }

    public Boolean isPublished() {
        return this.published;
    }

    public DatasetEntity setPublished(boolean published) {
        this.published = published;
        return this;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public DatasetEntity setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public DatasetEntity setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public DatasetType getDatasetType() {
        return this.datasetType;
    }

    public DatasetEntity setDatasetType(DatasetType datasetType) {
        this.datasetType = datasetType;
        return this;
    }

    public ObservationType getObservationType() {
        return this.observationType;
    }

    public DatasetEntity setObservationType(ObservationType observationType) {
        this.observationType = observationType;
        return this;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public DatasetEntity setValueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public List<DatasetEntity> getReferenceValues() {
        return this.referenceValues;
    }

    public DatasetEntity setReferenceValues(List<DatasetEntity> referenceValues) {
        this.referenceValues = referenceValues;
        return this;
    }

    public boolean hasReferenceValues() {
        return this.getReferenceValues() != null && !this.getReferenceValues().isEmpty();
    }

    public Integer getNumberOfDecimals() {
        return this.numberOfDecimals;
    }

    public DatasetEntity setNumberOfDecimals(Integer numberOfDecimals) {
        this.numberOfDecimals = numberOfDecimals;
        return this;
    }

    public DatasetEntity setObservationCount(long count) {
        this.observationCount = count;
        return this;
    }

    public long getObservationCount() {
        return this.observationCount;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public DatasetEntity setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public DatasetEntity setMobile(boolean mobile) {
        this.mobile = mobile;
        return this;
    }

    public boolean isInsitu() {
        return this.insitu;
    }

    public DatasetEntity setInsitu(boolean insitu) {
        this.insitu = insitu;
        return this;
    }

    public String getOriginTimezone() {
        return this.originTimezone;
    }

    public DatasetEntity setOriginTimezone(String originTimezone) {
        this.originTimezone = originTimezone;
        return this;
    }

    public boolean isSetOriginTimezone() {
        return this.getOriginTimezone() != null && !this.getOriginTimezone().isEmpty();
    }

    public DateTimeZone getDateTimeZone() {
        if (this.timeZone == null) {
            if (this.originTimezone != null && !this.originTimezone.isEmpty()) {
                this.timeZone = this.originTimezone.matches(OFFSET_REGEX) ? DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(ZoneOffset.of(this.originTimezone).normalized())) : DateTimeZone.forID((String)this.originTimezone.trim());
            }
            this.timeZone = DateTimeZone.UTC;
        }
        return this.timeZone;
    }

    public Set<RelatedDatasetEntity> getRelatedDatasets() {
        return this.relatedDatasets;
    }

    public DatasetEntity setRelatedObservations(Set<RelatedDatasetEntity> relatedDataset) {
        this.relatedDatasets = relatedDataset;
        return this;
    }

    public boolean hasRelatedDatasets() {
        return this.getRelatedDatasets() != null && !this.getRelatedDatasets().isEmpty();
    }

    public VerticalMetadataEntity getVerticalMetadata() {
        return this.verticalMetadata;
    }

    public DatasetEntity setVerticalMetadata(VerticalMetadataEntity verticalMetadata) {
        this.verticalMetadata = verticalMetadata;
        return this;
    }

    public boolean hasVerticalMetadata() {
        return this.getVerticalMetadata() != null;
    }

    public SamplingProfileDatasetEntity getSamplingProfile() {
        return this.samplingProfile;
    }

    public DatasetEntity setSamplingProfile(SamplingProfileDatasetEntity samplingProfile) {
        this.samplingProfile = samplingProfile;
        return this;
    }

    public boolean hasSamplingProfile() {
        return this.getSamplingProfile() != null;
    }

    public boolean getEreportingProfile() {
        return this.ereportingProfile;
    }

    public DatasetEntity setEreportingProfile(boolean ereportingProfile) {
        this.ereportingProfile = ereportingProfile;
        return this;
    }

    public boolean hasEreportingProfile() {
        return this.getEreportingProfile();
    }

    @Override
    public void setTags(Set<TagEntity> tags) {
        this.tags = tags;
    }

    @Override
    public Set<TagEntity> getTags() {
        return this.tags;
    }

    public void copy(DatasetEntity dataset) {
        this.setIdentifier(dataset.getIdentifier());
        this.setIdentifierCodespace(dataset.getIdentifierCodespace());
        this.setStaIdentifier(dataset.getStaIdentifier());
        this.setName(dataset.getName());
        this.setNameCodespace(dataset.getNameCodespace());
        this.setDescription(dataset.getDescription());
        if (dataset.getParameters() != null) {
            this.setParameters(dataset.getParameters().stream().collect(Collectors.toSet()));
        }
        this.setCategory(dataset.getCategory());
        this.setDeleted(dataset.isDeleted());
        this.setDisabled(dataset.isDisabled());
        this.setFeature(dataset.getFeature());
        this.setFirstObservation(dataset.getFirstObservation());
        this.setFirstQuantityValue(dataset.getFirstQuantityValue());
        this.setFirstValueAt(dataset.getFirstValueAt());
        this.setHidden(dataset.isHidden());
        this.setLastObservation(dataset.getLastObservation());
        this.setLastQuantityValue(dataset.getLastQuantityValue());
        this.setLastValueAt(dataset.getLastValueAt());
        this.setObservationCount(dataset.getObservationCount());
        this.setOMObservationType(dataset.getOMObservationType());
        this.setOffering(dataset.getOffering());
        this.setPhenomenon(dataset.getPhenomenon());
        this.setPlatform(dataset.getPlatform());
        this.setProcedure(dataset.getProcedure());
        this.setPublished(dataset.isPublished());
        this.setProcessed(dataset.isProcessed());
        this.setSamplingTimeStart(dataset.getSamplingTimeStart());
        this.setSamplingTimeEnd(dataset.getSamplingTimeEnd());
        this.setGeometryEntity(dataset.getGeometryEntity());
        this.setInsitu(dataset.isInsitu());
        this.setMobile(dataset.isMobile());
        this.setEreportingProfile(dataset.getEreportingProfile());
        if (dataset.getRelatedDatasets() != null) {
            this.setRelatedObservations(dataset.getRelatedDatasets().stream().collect(Collectors.toSet()));
        }
        if (dataset.getResultTimes() != null) {
            this.setResultTimes(dataset.getResultTimes().stream().collect(Collectors.toSet()));
        }
        if (dataset.hasSamplingProfile()) {
            this.setSamplingProfile(new SamplingProfileDatasetEntity().copy(dataset.getSamplingProfile()));
        }
        if (dataset.hasVerticalMetadata()) {
            this.setVerticalMetadata(dataset.getVerticalMetadata());
        }
        this.setUnit(dataset.getUnit());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" id: ").append(this.getId()).append(" , category: ").append(this.getCategory()).append(" , phenomenon: ").append(this.getPhenomenon()).append(" , procedure: ").append(this.getProcedure()).append(" , offering: ").append(this.getOffering()).append(" , feature: ").append(this.getFeature()).append(" , service: ").append(this.getService()).append(" ]").toString();
    }
}

