/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.FormatEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.beans.sta.AbstractDatastreamEntity;
import org.n52.series.db.common.Utils;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class AbstractDatasetEntity
extends DescribableEntity
implements Serializable,
HibernateRelations.IsStaEntity,
AbstractDatastreamEntity {
    public static final String PROPERTY_CATEGORY = "category";
    public static final String PROPERTY_OFFERING = "offering";
    public static final String PROPERTY_PROCEDURE = "procedure";
    public static final String PROPERTY_PLATFORM = "platform";
    public static final String PROPERTY_PHENOMENON = "phenomenon";
    public static final String PROPERTY_FEATURE = "feature";
    public static final String PROPERTY_OM_OBSERVATION_TYPE = "omObservationType";
    public static final String PROPERTY_FIRST_VALUE_AT = "firstValueAt";
    public static final String PROPERTY_LAST_VALUE_AT = "lastValueAt";
    public static final String PROPERTY_FIRST_OBSERVATION = "firstObservation";
    public static final String PROPERTY_LAST_OBSERVATION = "lastObservation";
    public static final String PROPERTY_RESULT_TIME_START = "resultTimeStart";
    public static final String PROPERTY_RESULT_TIME_END = "resultTimeEnd";
    public static final String PROPERTY_UNIT = "unit";
    public static final String PROPERTY_AGGREGATION = "aggregation";
    private static final long serialVersionUID = 4178505006632345142L;
    private AbstractFeatureEntity<?> feature;
    private PhenomenonEntity phenomenon;
    private ProcedureEntity procedure;
    private CategoryEntity category;
    private UnitEntity unit;
    private OfferingEntity offering;
    private PlatformEntity platform;
    private GeometryEntity observedArea;
    private Set<Date> resultTimes;
    private Date firstValueAt;
    private Date lastValueAt;
    private DataEntity<?> firstObservation;
    private DataEntity<?> lastObservation;
    private BigDecimal firstQuantityValue;
    private BigDecimal lastQuantityValue;
    private Date resultTimeStart;
    private Date resultTimeEnd;
    private FormatEntity omObservationType;
    private Set<DataEntity<?>> observations;
    private AbstractDatasetEntity aggregation;
    private boolean processed;

    public PhenomenonEntity getPhenomenon() {
        return this.phenomenon;
    }

    public void setPhenomenon(PhenomenonEntity phenomenon) {
        this.phenomenon = phenomenon;
    }

    @Override
    public PhenomenonEntity getObservableProperty() {
        return this.getPhenomenon();
    }

    @Override
    public void setObservableProperty(PhenomenonEntity observableProperty) {
        this.setPhenomenon(observableProperty);
    }

    @Override
    public ProcedureEntity getProcedure() {
        return this.procedure;
    }

    @Override
    public void setProcedure(ProcedureEntity procedure) {
        this.procedure = procedure;
    }

    @Override
    public AbstractFeatureEntity<?> getFeature() {
        return this.feature;
    }

    @Override
    public void setFeature(AbstractFeatureEntity<?> feature) {
        this.feature = feature;
    }

    public boolean isSetFeature() {
        return this.getFeature() != null;
    }

    @Override
    public OfferingEntity getOffering() {
        return this.offering;
    }

    @Override
    public void setOffering(OfferingEntity offering) {
        this.offering = offering;
    }

    public CategoryEntity getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEntity category) {
        this.category = category;
    }

    @Override
    public boolean isSetOffering() {
        return this.getOffering() != null;
    }

    @Override
    public PlatformEntity getPlatform() {
        return this.platform;
    }

    @Override
    public void setPlatform(PlatformEntity platform) {
        this.platform = platform;
    }

    public boolean isSetPlatform() {
        return this.getPlatform() != null;
    }

    public Date getFirstValueAt() {
        return Utils.createUnmutableTimestamp(this.firstValueAt);
    }

    public void setFirstValueAt(Date firstValueAt) {
        this.firstValueAt = Utils.createUnmutableTimestamp(firstValueAt);
    }

    public boolean isSetFirstValueAt() {
        return this.getFirstValueAt() != null;
    }

    public Date getLastValueAt() {
        return Utils.createUnmutableTimestamp(this.lastValueAt);
    }

    public void setLastValueAt(Date lastValueAt) {
        this.lastValueAt = Utils.createUnmutableTimestamp(lastValueAt);
    }

    public boolean isSetLastValueAt() {
        return this.getLastValueAt() != null;
    }

    public DataEntity<?> getFirstObservation() {
        return this.firstObservation;
    }

    public void setFirstObservation(DataEntity<?> firstObservation) {
        this.firstObservation = firstObservation;
    }

    public DataEntity<?> getLastObservation() {
        return this.lastObservation;
    }

    public void setLastObservation(DataEntity<?> lastObservation) {
        this.lastObservation = lastObservation;
    }

    public BigDecimal getFirstQuantityValue() {
        return this.firstQuantityValue;
    }

    public void setFirstQuantityValue(BigDecimal firstValue) {
        this.firstQuantityValue = firstValue;
    }

    public BigDecimal getLastQuantityValue() {
        return this.lastQuantityValue;
    }

    public void setLastQuantityValue(BigDecimal lastValue) {
        this.lastQuantityValue = lastValue;
    }

    @Override
    public Date getResultTimeStart() {
        return Utils.createUnmutableTimestamp(this.resultTimeStart);
    }

    @Override
    public void setResultTimeStart(Date resultTimeStart) {
        this.resultTimeStart = Utils.createUnmutableTimestamp(resultTimeStart);
    }

    public boolean isSetResultTimeStart() {
        return this.getResultTimeStart() != null;
    }

    @Override
    public Date getResultTimeEnd() {
        return Utils.createUnmutableTimestamp(this.resultTimeEnd);
    }

    @Override
    public void setResultTimeEnd(Date resultTimeEnd) {
        this.resultTimeEnd = Utils.createUnmutableTimestamp(resultTimeEnd);
    }

    public boolean isSetResultTimeEnd() {
        return this.getResultTimeEnd() != null;
    }

    public Set<Date> getResultTimes() {
        Set<Date> unmodifiableResultTimes = this.wrapToUnmutables(this.resultTimes);
        return unmodifiableResultTimes != null ? Collections.unmodifiableSet(unmodifiableResultTimes) : null;
    }

    public void setResultTimes(Set<Date> resultTimes) {
        this.resultTimes = this.wrapToUnmutables(resultTimes);
    }

    @Override
    public UnitEntity getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(UnitEntity unit) {
        this.unit = unit;
    }

    public String getUnitI18nName(String locale) {
        return this.unit != null ? this.unit.getUnit() : "";
    }

    @Override
    public FormatEntity getOMObservationType() {
        return this.omObservationType;
    }

    @Override
    public void setOMObservationType(FormatEntity omObservationType) {
        this.omObservationType = omObservationType;
    }

    @Override
    public boolean isSetOMObservationType() {
        return this.getOMObservationType() != null && this.getOMObservationType().isSetFormat();
    }

    public FormatEntity getOmObservationType() {
        return this.omObservationType;
    }

    public void setOmObservationType(FormatEntity omObservationType) {
        this.omObservationType = omObservationType;
    }

    @Override
    public GeometryEntity getGeometryEntity() {
        return this.observedArea;
    }

    @Override
    public void setGeometry(Geometry geometry) {
        this.observedArea = new GeometryEntity();
        this.observedArea.setGeometry(geometry);
        this.observedArea.setSrid(geometry.getSRID());
    }

    @Override
    public void setGeometryEntity(GeometryEntity geometryEntity) {
        this.observedArea = geometryEntity;
    }

    @Override
    public Date getSamplingTimeStart() {
        return this.getFirstValueAt();
    }

    @Override
    public void setSamplingTimeStart(Date samplingTimeStart) {
        this.setFirstValueAt(samplingTimeStart);
    }

    @Override
    public Date getSamplingTimeEnd() {
        return this.getLastValueAt();
    }

    @Override
    public void setSamplingTimeEnd(Date samplingTimeEnd) {
        this.setLastValueAt(samplingTimeEnd);
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public void setProcessed(boolean processsed) {
        this.processed = processsed;
    }

    @Override
    public void setObservations(Set<DataEntity<?>> observations) {
        this.observations = observations;
    }

    @Override
    public Set<DataEntity<?>> getObservations() {
        return this.observations;
    }

    public AbstractDatasetEntity getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(AbstractDatasetEntity aggregation) {
        this.aggregation = aggregation;
    }

    public boolean isSetAggregation() {
        return this.getAggregation() != null;
    }

    @Override
    public String getLabelFrom(String locale) {
        if (this.isSetName()) {
            return super.getLabelFrom(locale);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.phenomenon.getLabelFrom(locale)).append(" ");
        sb.append(this.procedure.getLabelFrom(locale)).append(", ");
        sb.append(this.feature.getLabelFrom(locale)).append(", ");
        return sb.append(this.offering.getLabelFrom(locale)).toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DatasetEntity)) {
            return false;
        }
        return super.equals(obj);
    }

    private Set<Date> wrapToUnmutables(Set<Date> dates) {
        return dates != null ? dates.stream().map(d -> d != null ? new Timestamp(d.getTime()) : null).collect(Collectors.toSet()) : null;
    }
}

