/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans.sta;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FormatEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.PlatformEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.UnitEntity;
import org.n52.series.db.beans.sta.AbstractObservationEntity;
import org.n52.series.db.beans.sta.StaDescribableEntity;
import org.n52.series.db.common.Utils;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class DatastreamEntity
extends StaDescribableEntity
implements Serializable,
HibernateRelations.HasObservationType<DatastreamEntity>,
HibernateRelations.HasObservableProperty<DatastreamEntity>,
HibernateRelations.HasPhenomenonTime,
HibernateRelations.HasUnit,
HibernateRelations.HasProcedure<DatastreamEntity>,
HibernateRelations.HasGeometry<DatastreamEntity> {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_OBSERVATION_TYPE = "observationType";
    public static final String PROPERTY_UNIT = "unitOfMeasurement";
    public static final String PROPERTY_OBSERVED_AREA = "observedArea";
    public static final String PROPERTY_SAMPLING_TIME_START = "samplingTimeStart";
    public static final String PROPERTY_SAMPLING_TIME_END = "samplingTimeEnd";
    public static final String PROPERTY_RESULT_TIME_START = "resultTimeStart";
    public static final String PROPERTY_RESULT_TIME_END = "resultTimeEnd";
    public static final String PROPERTY_THING = "thing";
    public static final String PROPERTY_SENSOR = "procedure";
    public static final String PROPERTY_OBSERVABLE_PROPERTY = "observableProperty";
    public static final String PROPERTY_DATASETS = "datasets";
    public static final String PROPERTY_OBSERVATIONS = "observations";
    private static final long serialVersionUID = -9067390076853876658L;
    private GeometryEntity geometryEntity;
    private Date samplingTimeStart;
    private Date samplingTimeEnd;
    private Date resultTimeStart;
    private Date resultTimeEnd;
    private FormatEntity observationType;
    private UnitEntity unitOfMeasurement;
    private PlatformEntity thing;
    private ProcedureEntity procedure;
    private PhenomenonEntity observableProperty;
    private Set<DatasetEntity> datasets;
    private Set<AbstractObservationEntity> observations;

    @Override
    public Date getSamplingTimeStart() {
        return Utils.createUnmutableTimestamp(this.samplingTimeStart);
    }

    @Override
    public void setSamplingTimeStart(Date samplingTimeStart) {
        this.samplingTimeStart = Utils.createUnmutableTimestamp(samplingTimeStart);
    }

    @Override
    public Date getSamplingTimeEnd() {
        return Utils.createUnmutableTimestamp(this.samplingTimeEnd);
    }

    @Override
    public void setSamplingTimeEnd(Date samplingTimeEnd) {
        this.samplingTimeEnd = Utils.createUnmutableTimestamp(samplingTimeEnd);
    }

    public Date getResultTimeStart() {
        return Utils.createUnmutableTimestamp(this.resultTimeStart);
    }

    public DatastreamEntity setResultTimeStart(Date resultTimeStart) {
        this.resultTimeStart = Utils.createUnmutableTimestamp(resultTimeStart);
        return this;
    }

    public boolean hasResultTimeStart() {
        return this.getResultTimeStart() != null;
    }

    public Date getResultTimeEnd() {
        return Utils.createUnmutableTimestamp(this.resultTimeEnd);
    }

    public DatastreamEntity setResultTimeEnd(Date resultTimeEnd) {
        this.resultTimeEnd = Utils.createUnmutableTimestamp(resultTimeEnd);
        return this;
    }

    public boolean hasResultTimeEnd() {
        return this.getResultTimeEnd() != null;
    }

    @Override
    public UnitEntity getUnit() {
        return this.unitOfMeasurement;
    }

    @Override
    public void setUnit(UnitEntity unit) {
        this.unitOfMeasurement = unit;
    }

    @Override
    public boolean isSetUnit() {
        return this.getUnitOfMeasurement() != null && this.getUnitOfMeasurement().isSetIdentifier();
    }

    public Set<DatasetEntity> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(Set<DatasetEntity> datasets) {
        this.datasets = datasets;
    }

    public void addDataset(DatasetEntity dataset) {
        if (this.datasets == null) {
            this.datasets = new LinkedHashSet<DatasetEntity>();
        }
        this.datasets.add(dataset);
    }

    @Override
    public FormatEntity getObservationType() {
        return this.observationType;
    }

    @Override
    public DatastreamEntity setObservationType(FormatEntity observationType) {
        this.observationType = observationType;
        return this;
    }

    @Override
    public boolean isSetObservationType() {
        return this.observationType != null;
    }

    public PlatformEntity getThing() {
        return this.thing;
    }

    public DatastreamEntity setThing(PlatformEntity thing) {
        this.thing = thing;
        return this;
    }

    public boolean hasThing() {
        return this.thing != null;
    }

    @Override
    public DatastreamEntity setProcedure(ProcedureEntity procedure) {
        this.procedure = procedure;
        return this;
    }

    @Override
    public ProcedureEntity getProcedure() {
        return this.procedure;
    }

    public boolean hasProcedure() {
        return this.procedure != null;
    }

    public UnitEntity getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    public DatastreamEntity setUnitOfMeasurement(UnitEntity unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
        return this;
    }

    @Override
    public GeometryEntity getGeometryEntity() {
        return this.geometryEntity;
    }

    @Override
    public DatastreamEntity setGeometry(Geometry geometry) {
        this.geometryEntity = new GeometryEntity();
        this.geometryEntity.setGeometry(geometry);
        this.geometryEntity.setSrid(geometry.getSRID());
        return this;
    }

    @Override
    public DatastreamEntity setGeometryEntity(GeometryEntity geometryEntity) {
        this.geometryEntity = geometryEntity;
        return this;
    }

    @Override
    public DatastreamEntity setObservableProperty(PhenomenonEntity observableProperty) {
        this.observableProperty = observableProperty;
        return this;
    }

    @Override
    public PhenomenonEntity getObservableProperty() {
        return this.observableProperty;
    }

    public DatastreamEntity setObservations(Set<AbstractObservationEntity> observations) {
        this.observations = observations;
        return this;
    }

    public Set<AbstractObservationEntity> getObservations() {
        return this.observations;
    }

    public boolean hasObservableProperty() {
        return this.observableProperty != null;
    }

    public boolean hasObservations() {
        return this.getObservations() != null && !this.getObservations().isEmpty();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DatastreamEntity)) {
            return false;
        }
        return super.equals(obj);
    }
}

