/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.n52.series.db.beans.CountDataEntity;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.QuantityDataEntity;
import org.n52.series.db.beans.ServiceMetadataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEntity
extends DescribableEntity {
    private static final long serialVersionUID = 8926184900932191238L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceEntity.class);
    private String url;
    private String type = "RESTful series data access layer.";
    private List<String> noDataValues = Collections.emptyList();
    private String version;
    private boolean supportsFirstLast = true;
    private String connector;
    private ServiceMetadataEntity serviceMetadata;
    private Collection<BigDecimal> quantityNoDataValues;
    private Collection<Integer> countNoDataValues;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNoDataValue(DataEntity<?> observation) {
        return !observation.hasDetectionLimit() && this.checkNoDataValue(observation);
    }

    public String getNoDataValues() {
        return String.join((CharSequence)",", this.noDataValues);
    }

    public void setNoDataValues(String noDataValues) {
        LOGGER.debug("Set noData values: {}", (Object)noDataValues);
        if (noDataValues == null || noDataValues.isEmpty()) {
            this.noDataValues = Collections.emptyList();
        } else {
            String[] values = noDataValues.split(",");
            this.noDataValues = Arrays.asList(values);
            this.quantityNoDataValues = this.convertToBigDecimal(this.noDataValues);
            this.countNoDataValues = this.convertToIntegers(this.noDataValues);
        }
    }

    public boolean getSupportsFirstLast() {
        return this.supportsFirstLast;
    }

    public void setSupportsFirstLast(boolean supportsFirstLast) {
        this.supportsFirstLast = supportsFirstLast;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getConnector() {
        return this.connector;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public ServiceMetadataEntity getServiceMetadata() {
        return this.serviceMetadata;
    }

    public void setServiceMetadata(ServiceMetadataEntity serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    public boolean isSetServiceMetadata() {
        return this.getServiceMetadata() != null && this.getServiceMetadata().isSetMetadata();
    }

    private boolean checkNoDataValue(DataEntity<?> observation) {
        if (observation instanceof QuantityDataEntity) {
            return ((QuantityDataEntity)observation).checkNoDataValue(this.quantityNoDataValues);
        }
        if (observation instanceof CountDataEntity) {
            return ((CountDataEntity)observation).checkNoDataValue(this.countNoDataValues);
        }
        return observation.isNoDataValue(this.noDataValues);
    }

    private Collection<BigDecimal> convertToBigDecimal(Collection<String> collection) {
        ArrayList<BigDecimal> validatedValues = new ArrayList<BigDecimal>();
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                validatedValues.add(new BigDecimal(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Ignoring NO_DATA value {} (not a big decimal value).", (Object)trimmed);
            }
        }
        return validatedValues;
    }

    private Collection<Integer> convertToIntegers(Collection<String> collection) {
        ArrayList<Integer> validatedValues = new ArrayList<Integer>();
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                validatedValues.add(Integer.parseInt(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Ignoring NO_DATA value {} (not an integer).", (Object)trimmed);
            }
        }
        return validatedValues;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getClass().getSimpleName()).append(" [").append(" url: ").append(this.getUrl()).append(", type: ").append(this.getType()).append(", version: ").append(this.getVersion()).append(", noDataValues: ").append(this.getNoDataValues()).append(" ]").toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServiceEntity)) {
            return false;
        }
        return super.equals(obj);
    }
}

