/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.NumericalDataEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantityDataEntity
extends DataEntity<BigDecimal>
implements NumericalDataEntity<BigDecimal> {
    public static final BigDecimal DOUBLE_THRESHOLD = BigDecimal.valueOf(1.0E-4);
    private static final Logger LOGGER = LoggerFactory.getLogger(QuantityDataEntity.class);
    private static final long serialVersionUID = 7619426522406105659L;

    @Override
    public boolean isNoDataValue(Collection<String> noDataValues) {
        return this.getValue() == null ? false : this.containsValue(noDataValues, (BigDecimal)this.getValue());
    }

    @Override
    public boolean checkNoDataValue(Collection<BigDecimal> noDataValues) {
        return this.getValue() == null ? false : this.checkValue(noDataValues, (BigDecimal)this.getValue());
    }

    private boolean checkValue(Collection<BigDecimal> collection, BigDecimal value) {
        if (collection == null) {
            return false;
        }
        for (BigDecimal noDataValue : collection) {
            if (noDataValue.subtract(value).abs().compareTo(DOUBLE_THRESHOLD) >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean containsValue(Collection<String> collection, BigDecimal value) {
        if (collection == null) {
            return false;
        }
        return this.checkValue(this.convertToDoubles(collection), value);
    }

    private Collection<BigDecimal> convertToDoubles(Collection<String> collection) {
        ArrayList<BigDecimal> validatedValues = new ArrayList<BigDecimal>();
        for (String value : collection) {
            String trimmed = value.trim();
            try {
                validatedValues.add(new BigDecimal(trimmed));
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Ignoring NO_DATA value {} (not a big decimal value).", (Object)trimmed);
            }
        }
        return validatedValues;
    }
}

