/*
 * Decompiled with CFR 0.152.
 */
package org.n52.series.db.beans;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.n52.series.db.beans.FormatEntity;
import org.n52.series.db.beans.GeometryEntity;
import org.n52.series.db.beans.HibernateRelations;
import org.n52.series.db.beans.HierarchicalEntity;
import org.n52.series.db.beans.RelatedFeatureEntity;
import org.n52.series.db.common.Utils;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class OfferingEntity
extends HierarchicalEntity<OfferingEntity>
implements HibernateRelations.HasObservationTypes<OfferingEntity>,
HibernateRelations.HasFeatureTypes<OfferingEntity>,
HibernateRelations.HasRelatedFeatures<OfferingEntity>,
HibernateRelations.HasPhenomenonTime,
HibernateRelations.HasResultTimes<OfferingEntity>,
HibernateRelations.HasValidTime<OfferingEntity> {
    public static final String PROPERTY_PHENOMENON_TIME_START = "phenomenonTimeStart";
    public static final String PROPERTY_PHENOMENON_TIME_END = "phenomenonTimeEnd";
    public static final String PROPERTY_RESULT_TIME_START = "resultTimeStart";
    public static final String PROPERTY_RESULT_TIME_END = "resultTimeEnd";
    private static final long serialVersionUID = 5862607025737865794L;
    private GeometryEntity geometryEntity;
    private Set<FormatEntity> observationTypes;
    private Set<FormatEntity> featureTypes;
    private Date phenomenonTimeStart;
    private Date phenomenonTimeEnd;
    private Date resultTimeStart;
    private Date resultTimeEnd;
    private Set<RelatedFeatureEntity> relatedFeatures;
    private Date validTimeStart;
    private Date validTimeEnd;

    public Geometry getGeometry() {
        return this.geometryEntity != null ? this.geometryEntity.getGeometry() : null;
    }

    public OfferingEntity setGeometry(Geometry geometry) {
        this.geometryEntity = new GeometryEntity();
        this.geometryEntity.setGeometry(geometry);
        this.geometryEntity.setSrid(geometry.getSRID());
        return this;
    }

    public void setGeometryEntity(GeometryEntity geometryEntity) {
        this.geometryEntity = geometryEntity;
    }

    public GeometryEntity getGeometryEntity() {
        return this.geometryEntity;
    }

    public boolean isSetGeometry() {
        return this.geometryEntity != null;
    }

    @Override
    public Set<FormatEntity> getObservationTypes() {
        return this.observationTypes;
    }

    @Override
    public OfferingEntity setObservationTypes(Set<FormatEntity> observationTypes) {
        this.observationTypes = observationTypes;
        return this;
    }

    @Override
    public Set<FormatEntity> getFeatureTypes() {
        return this.featureTypes;
    }

    @Override
    public OfferingEntity setFeatureTypes(Set<FormatEntity> featureTypes) {
        this.featureTypes = featureTypes;
        return this;
    }

    @Override
    public Date getSamplingTimeStart() {
        return Utils.createUnmutableTimestamp(this.phenomenonTimeStart);
    }

    @Override
    public void setSamplingTimeStart(Date time) {
        this.phenomenonTimeStart = Utils.createUnmutableTimestamp(time);
    }

    @Override
    public Date getSamplingTimeEnd() {
        return Utils.createUnmutableTimestamp(this.phenomenonTimeEnd);
    }

    @Override
    public void setSamplingTimeEnd(Date time) {
        this.phenomenonTimeEnd = Utils.createUnmutableTimestamp(time);
    }

    @Override
    public Date getResultTimeStart() {
        return Utils.createUnmutableTimestamp(this.resultTimeStart);
    }

    @Override
    public OfferingEntity setResultTimeStart(Date resultTimeStart) {
        this.resultTimeStart = Utils.createUnmutableTimestamp(resultTimeStart);
        return this;
    }

    @Override
    public Date getResultTimeEnd() {
        return Utils.createUnmutableTimestamp(this.resultTimeEnd);
    }

    @Override
    public OfferingEntity setResultTimeEnd(Date resultTimeEnd) {
        this.resultTimeEnd = Utils.createUnmutableTimestamp(resultTimeEnd);
        return this;
    }

    @Override
    public Date getValidTimeStart() {
        return Utils.createUnmutableTimestamp(this.validTimeStart);
    }

    @Override
    public OfferingEntity setValidTimeStart(Date validTimeStart) {
        this.validTimeStart = Utils.createUnmutableTimestamp(validTimeStart);
        return this;
    }

    @Override
    public Date getValidTimeEnd() {
        return Utils.createUnmutableTimestamp(this.validTimeEnd);
    }

    @Override
    public OfferingEntity setValidTimeEnd(Date validTimeEnd) {
        this.validTimeEnd = Utils.createUnmutableTimestamp(validTimeEnd);
        return this;
    }

    @Override
    public boolean isSetValidTime() {
        return this.getValidTimeStart() != null && this.getValidTimeEnd() != null;
    }

    @Override
    public Set<RelatedFeatureEntity> getRelatedFeatures() {
        return this.relatedFeatures;
    }

    @Override
    public OfferingEntity setRelatedFeatures(Set<RelatedFeatureEntity> relatedFeatures) {
        this.relatedFeatures = relatedFeatures;
        return this;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OfferingEntity)) {
            return false;
        }
        return super.equals(obj);
    }
}

