/*
 * Decompiled with CFR 0.152.
 */
package org.n52.hibernate.spatial.dialect.postgis;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.spatial.dialect.postgis.PostgisPG95Dialect;

public class TimestampWithTimeZonePostgisPG95Dialect
extends PostgisPG95Dialect {
    private static final long serialVersionUID = -3409681181015765469L;

    public TimestampWithTimeZonePostgisPG95Dialect() {
        this.registerColumnType(93, "timestamp with time zone");
    }

    public String buildSqlCreateSpatialIndexString(Index index, String defaultCatalog, String defaultSchema) {
        String name = index.getName();
        Table table = index.getTable();
        Iterator columns = index.getColumnIterator();
        StringBuilder buf = new StringBuilder("create").append(" index ").append(this.qualifyIndexName() ? name : StringHelper.unqualify((String)name)).append(" on ").append(table.getQualifiedName((Dialect)this, defaultCatalog, defaultSchema)).append(" USING GIST").append(" (");
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            buf.append(column.getQuotedName((Dialect)this));
            if (!columns.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }
}

