/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.repositories;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.n52.sensorweb.server.db.repositories.ParameterDataRepository;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface ParameterServiceRepository<T extends DescribableEntity>
extends ParameterDataRepository<T> {
    default public Optional<T> findByIdentifierAndService(T entity) {
        return this.findOne(this.createExample(entity, this.createMatcher()));
    }

    @Override
    default public T getInstance(T entity) {
        return (T)((DescribableEntity)this.findByIdentifierAndService(this.createIdentifierServiceExample(entity)).orElse(null));
    }

    default public Example<T> createExample(T entity, ExampleMatcher matcher) {
        return Example.of(entity, (ExampleMatcher)matcher);
    }

    default public ExampleMatcher createMatcher() {
        return ExampleMatcher.matching().withIgnorePaths(this.getMatcherIgnorePaths().toArray(new String[0])).withMatcher("identifier", ExampleMatcher.GenericPropertyMatchers.exact()).withMatcher("service", ExampleMatcher.GenericPropertyMatchers.exact());
    }

    default public Set<String> getMatcherIgnorePaths() {
        HashSet<String> paths = new HashSet<String>();
        paths.add("id");
        paths.add("staIdentifier");
        return paths;
    }

    default public <T extends DescribableEntity> T createIdentifierServiceExample(T entity) {
        try {
            DescribableEntity example = (DescribableEntity)entity.getClass().newInstance();
            example.setIdentifier(entity.getIdentifier());
            example.setService(entity.getService());
            return (T)example;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
            return entity;
        }
    }

    public List<T> findByService(ServiceEntity var1);

    default public List<T> findByService(T entity, ServiceEntity service) {
        entity.setService(service);
        return this.findAll(this.createExample(entity, this.createMatcher()));
    }

    default public void deleteByService(ServiceEntity service) {
        this.deleteAll(this.findByService(service));
    }
}

