/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.query;

import java.util.Collection;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.n52.io.request.IoParameters;
import org.n52.sensorweb.server.db.old.dao.DbQuery;
import org.n52.sensorweb.server.db.old.dao.DefaultDbQueryFactory;
import org.n52.sensorweb.server.db.old.dao.QueryUtils;

public abstract class QuerySpecifications {
    protected final DbQuery dbQuery;
    protected final EntityManager entityManager;

    protected QuerySpecifications(DbQuery dbQuery, EntityManager entityManager) {
        this.dbQuery = dbQuery == null ? new DefaultDbQueryFactory().createFrom(IoParameters.createDefaults()) : dbQuery;
        this.entityManager = entityManager;
    }

    protected Date getTimespanStart() {
        DateTime start = this.getTimespan().getStart();
        return start.toDate();
    }

    protected Date getTimespanEnd() {
        DateTime end = this.getTimespan().getEnd();
        return end.toDate();
    }

    private Interval getTimespan() {
        return this.dbQuery.getTimespan();
    }

    protected Predicate getIdPredicate(Join<?, ?> join, Collection<String> ids) {
        return this.dbQuery.isMatchDomainIds() ? join.get("identifier").in(ids) : join.get("id").in(QueryUtils.parseToIds(ids));
    }
}

