/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.query;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.ParameterRegistry;
import org.hibernate.query.criteria.internal.Renderable;
import org.hibernate.query.criteria.internal.compile.RenderingContext;
import org.hibernate.query.criteria.internal.predicate.AbstractSimplePredicate;
import org.hibernate.spatial.SpatialDialect;
import org.locationtech.jts.geom.Geometry;

public class IntersectsPredicate
extends AbstractSimplePredicate
implements Expression<Boolean>,
Serializable {
    private static final long serialVersionUID = -5467642277075037085L;
    private final Expression<Geometry> matchExpression;
    private final Expression<Geometry> matchingExprssion;
    private EntityManager entityManager;

    public IntersectsPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<Geometry> matchExpression, Expression<Geometry> matchingExprssion, EntityManager entityManager) {
        super(criteriaBuilder);
        this.matchExpression = matchExpression;
        this.matchingExprssion = matchingExprssion;
        this.entityManager = entityManager;
    }

    public Expression<Geometry> getMatchExpression() {
        return this.matchExpression;
    }

    public Expression<Geometry> getMatchingExprssion() {
        return this.matchingExprssion;
    }

    public void registerParameters(ParameterRegistry registry) {
    }

    public String render(boolean isNegated, RenderingContext renderingContext) {
        if (this.getDialect() != null && this.getDialect() instanceof SpatialDialect) {
            SpatialDialect dialect = (SpatialDialect)this.getDialect();
            StringBuilder buffer = new StringBuilder("(");
            buffer.append(dialect.getSpatialRelateSQL(((Renderable)this.getMatchExpression()).render(renderingContext), 7));
            buffer.append(") = TRUE");
            String spatialRelateSQL = dialect.getSpatialRelateSQL(((Renderable)this.getMatchExpression()).render(renderingContext), 7);
            spatialRelateSQL = buffer.toString();
            return spatialRelateSQL.replace("?", ((Renderable)this.getMatchingExprssion()).render(renderingContext));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(" ST_Intersects(").append(((Renderable)this.getMatchExpression()).render(renderingContext)).append(", ").append(((Renderable)this.getMatchingExprssion()).render(renderingContext)).append(" ) = TRUE");
        String bo = buffer.toString();
        return bo;
    }

    private Dialect getDialect() {
        if (this.entityManager != null) {
            Session session = (Session)this.entityManager.getDelegate();
            return ((JdbcServices)((SessionFactoryImplementor)session.getSessionFactory()).getServiceRegistry().getService(JdbcServices.class)).getDialect();
        }
        return null;
    }
}

