/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.query;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.expression.LiteralExpression;
import org.locationtech.jts.geom.Geometry;
import org.n52.sensorweb.server.db.old.dao.DbQuery;
import org.n52.sensorweb.server.db.query.IntersectsPredicate;
import org.n52.sensorweb.server.db.query.ParameterQuerySpecifications;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.springframework.data.jpa.domain.Specification;

public final class FeatureQuerySpecifications
extends ParameterQuerySpecifications {
    private FeatureQuerySpecifications(DbQuery dbQuery, EntityManager entityManager) {
        super(dbQuery, entityManager);
    }

    public static FeatureQuerySpecifications of(DbQuery dbQuery, EntityManager entityManager) {
        return new FeatureQuerySpecifications(dbQuery, entityManager);
    }

    public Specification<AbstractFeatureEntity> selectFrom(Specification<DatasetEntity> filter, String id) {
        return (Specification & Serializable)(root, query, builder) -> {
            Subquery sq = query.subquery(Long.class);
            Root dataset = sq.from(DatasetEntity.class);
            sq.select((Expression)dataset.get("feature").get("id")).where((Expression)filter.toPredicate(dataset, query, builder));
            return builder.or((Expression)builder.in((Expression)root.get("id")).value((Expression)sq), (Expression)builder.and((Expression)builder.equal((Expression)root.get("id"), (Object)id), (Expression)builder.isNotEmpty((Expression)root.get("children"))));
        };
    }

    public Specification<AbstractFeatureEntity> selectFrom(Specification<DatasetEntity> filter) {
        return (Specification & Serializable)(root, query, builder) -> {
            Subquery sq = query.subquery(Long.class);
            Root dataset = sq.from(DatasetEntity.class);
            sq.select((Expression)dataset.get("feature").get("id")).where((Expression)filter.toPredicate(dataset, query, builder));
            return builder.in((Expression)root.get("id")).value((Expression)sq);
        };
    }

    public Specification<AbstractFeatureEntity> matchesSpatially() {
        Geometry geometry = this.dbQuery.getSpatialFilter();
        if (geometry == null || geometry.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> new IntersectsPredicate((CriteriaBuilderImpl)builder, (Expression<Geometry>)root.get("geometryEntity").get("geometry"), (Expression<Geometry>)new LiteralExpression((CriteriaBuilderImpl)builder, (Object)geometry), this.entityManager);
    }
}

