/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.old.dao;

import java.util.Optional;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MoreRestrictions;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.n52.sensorweb.server.db.old.dao.FESCriterionGenerator;
import org.n52.sensorweb.server.db.old.dao.QueryUtils;
import org.n52.series.db.beans.DataEntity;
import org.n52.shetland.ogc.filter.ComparisonFilter;
import org.n52.shetland.ogc.filter.Filter;
import org.n52.shetland.ogc.filter.SpatialFilter;

public class DatasetFESCriterionGenerator
extends FESCriterionGenerator {
    public DatasetFESCriterionGenerator(Criteria criteria, boolean unsupportedIsTrue, boolean matchDomainIds, boolean complexParent) {
        super(criteria, unsupportedIsTrue, matchDomainIds, complexParent);
    }

    @Override
    protected Criterion createDataCriterion(Criterion criterion) {
        DetachedCriteria subquery = DetachedCriteria.forClass(DataEntity.class).setProjection((Projection)Projections.property((String)"dataset")).add((Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)).add(criterion);
        return Subqueries.propertyIn((String)"id", (DetachedCriteria)subquery);
    }

    @Override
    protected Criterion createDatasetCriterion(String property, ComparisonFilter filter) {
        Object value;
        if (this.isMatchDomainIds()) {
            filter.setValueReference("identifier");
            value = filter.getValue();
        } else {
            filter.setValueReference("id");
            Optional<Long> id = DatasetFESCriterionGenerator.parseLong(filter.getValue());
            if (!id.isPresent()) {
                return this.unsupported((Filter<?>)filter);
            }
            value = id.get();
        }
        String alias = this.addAlias(property);
        filter.setValueReference(QueryUtils.createAssociation(alias, filter.getValueReference()));
        return this.createComparison(filter, value);
    }

    @Override
    protected Criterion createDatasetCriterion(String property, SpatialFilter filter) {
        String alias = this.addAlias(property);
        filter.setValueReference(QueryUtils.createAssociation(alias, filter.getValueReference()));
        return this.createSpatialFilterCriterion(filter);
    }

    @Override
    protected Criterion createResultCriterion(ComparisonFilter filter) {
        return this.getResultSubqueries(filter).map(q -> q.setProjection((Projection)Projections.property((String)"dataset"))).map(q -> Subqueries.propertyIn((String)"id", (DetachedCriteria)q)).collect(MoreRestrictions.toDisjunction());
    }
}

