/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.old;

import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.EntityType;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.OuterJoinLoadable;

public final class DataModelUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPropertyNameSupported(String property, Class<?> clazz, Session session) {
        Transaction transaction = session.beginTransaction();
        try {
            boolean bl = DataModelUtil.hasProperty(property, session.getEntityManagerFactory().getMetamodel().entity(clazz));
            return bl;
        }
        finally {
            transaction.rollback();
        }
    }

    public static boolean isPropertyNameSupported(String property, Class<?> clazz, Criteria criteria) {
        return DataModelUtil.isPropertyNameSupported(property, clazz, DataModelUtil.extractSessionFactory(criteria).getCurrentSession());
    }

    private static boolean hasProperty(String property, EntityType<?> entityType) {
        return entityType.getAttributes().stream().map(a -> a.getName()).collect(Collectors.toSet()).contains(property);
    }

    public static boolean isNamedQuerySupported(String namedQuery, Session session) {
        SessionFactoryImplementor factory = DataModelUtil.getSessionFactory(session);
        NamedQueryDefinition namedQueryDef = factory.getNamedQuery(namedQuery);
        NamedSQLQueryDefinition namedSQLQueryDef = factory.getNamedSQLQuery(namedQuery);
        return namedQueryDef != null || namedSQLQueryDef != null;
    }

    private static SessionFactoryImplementor getSessionFactory(Session session) {
        return ((SessionImpl)session).getSessionFactory();
    }

    public static String getSqlString(Criteria criteria) {
        CriteriaImpl criteriaImpl = (CriteriaImpl)criteria;
        SharedSessionContractImplementor session = criteriaImpl.getSession();
        SessionFactoryImplementor factory = DataModelUtil.extractSessionFactory(criteria);
        CriteriaQueryTranslator translator = new CriteriaQueryTranslator(factory, criteriaImpl, criteriaImpl.getEntityOrClassName(), "this_");
        String[] implementors = factory.getMetamodel().getImplementors(criteriaImpl.getEntityOrClassName());
        OuterJoinLoadable joinLoader = (OuterJoinLoadable)factory.getMetamodel().entityPersister(implementors[0]);
        CriteriaJoinWalker walker = new CriteriaJoinWalker(joinLoader, translator, factory, criteriaImpl, criteriaImpl.getEntityOrClassName(), session.getLoadQueryInfluencers());
        return walker.getSQLString();
    }

    public static boolean isEntitySupported(Class<?> clazz, Session session) {
        return session != null ? DataModelUtil.isEntitySupported(clazz, session.getEntityManagerFactory()) : false;
    }

    public static boolean isEntitySupported(Class<?> clazz, Criteria criteria) {
        return criteria != null ? DataModelUtil.isEntitySupported(clazz, (EntityManagerFactory)DataModelUtil.extractSessionFactory(criteria)) : false;
    }

    private static boolean isEntitySupported(Class<?> clazz, EntityManagerFactory factory) {
        if (factory != null && clazz != null) {
            return factory.getMetamodel().getEntities().stream().filter(e -> e.getJavaType().equals(clazz)).findFirst().isPresent();
        }
        return false;
    }

    public static EntityManagerFactory extractEntityManagerFactory(Criteria criteria) {
        SharedSessionContractImplementor session = DataModelUtil.getSessionImplementor(criteria);
        return session != null ? session.getFactory().getCurrentSession().getEntityManagerFactory() : null;
    }

    public static SessionFactoryImplementor extractSessionFactory(Criteria criteria) {
        SharedSessionContractImplementor session = DataModelUtil.getSessionImplementor(criteria);
        return session != null ? session.getFactory() : null;
    }

    private static SharedSessionContractImplementor getSessionImplementor(Criteria criteria) {
        SharedSessionContractImplementor session = null;
        if (criteria instanceof CriteriaImpl) {
            session = ((CriteriaImpl)criteria).getSession();
        } else if (criteria instanceof CriteriaImpl.Subcriteria) {
            CriteriaImpl temp = (CriteriaImpl)((CriteriaImpl.Subcriteria)criteria).getParent();
            session = temp.getSession();
        }
        return session;
    }

    private static CriteriaImpl getCriteriaImpl(Criteria criteria) {
        if (criteria instanceof CriteriaImpl.Subcriteria) {
            return (CriteriaImpl)((CriteriaImpl.Subcriteria)criteria).getParent();
        }
        if (criteria instanceof CriteriaImpl) {
            return (CriteriaImpl)criteria;
        }
        return null;
    }
}

