/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.query;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.n52.sensorweb.server.db.old.dao.DbQuery;
import org.n52.sensorweb.server.db.old.dao.QueryUtils;
import org.n52.sensorweb.server.db.query.ParameterQuerySpecifications;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.DescribableEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.springframework.data.jpa.domain.Specification;

public final class ServiceQuerySpecifications
extends ParameterQuerySpecifications {
    private ServiceQuerySpecifications(DbQuery dbQuery) {
        super(dbQuery, null);
    }

    public static ServiceQuerySpecifications of(DbQuery dbQuery) {
        return new ServiceQuerySpecifications(dbQuery);
    }

    public Specification<ServiceEntity> selectFrom(Specification<DatasetEntity> filter) {
        return (Specification & Serializable)(root, query, builder) -> {
            Subquery sq = query.subquery(Long.class);
            Root dataset = sq.from(DatasetEntity.class);
            sq.select((Expression)dataset.get("service").get("id")).where((Expression)filter.toPredicate(dataset, query, builder));
            return builder.in((Expression)root.get("id")).value((Expression)sq);
        };
    }

    @Override
    public <T extends DescribableEntity> Specification<T> matchServices(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> this.dbQuery.isMatchDomainIds() ? root.get("identifier").in(ids) : root.get("id").in(QueryUtils.parseToIds(ids));
    }
}

