/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.query;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.expression.LiteralExpression;
import org.locationtech.jts.geom.Geometry;
import org.n52.io.request.IoParameters;
import org.n52.sensorweb.server.db.old.dao.DbQuery;
import org.n52.sensorweb.server.db.old.dao.QueryUtils;
import org.n52.sensorweb.server.db.query.IntersectsPredicate;
import org.n52.sensorweb.server.db.query.QuerySpecifications;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.dataset.DatasetType;
import org.n52.series.db.beans.dataset.ObservationType;
import org.n52.series.db.beans.dataset.ValueType;
import org.springframework.data.jpa.domain.Specification;

public final class DatasetQuerySpecifications
extends QuerySpecifications {
    private DatasetQuerySpecifications(DbQuery dbQuery, EntityManager entityManager) {
        super(dbQuery, entityManager);
    }

    public static DatasetQuerySpecifications of(DbQuery dbQuery, EntityManager entityManager) {
        return new DatasetQuerySpecifications(dbQuery, entityManager);
    }

    public Specification<DatasetEntity> toSubquery(Specification<DatasetEntity> filter) {
        return filter;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Specification<DatasetEntity> matchFilters() {
        return this.isPublic().and(this.matchFeatures()).and(this.matchCategory()).and(this.matchPhenomena()).and(this.matchProcedures()).and(this.matchOfferings()).and(this.matchPlatforms()).and(this.matchTag()).and(this.matchDatasetTypes()).and(this.matchObservationTypes()).and(this.matchValueTypes()).and(this.matchesSpatially()).and(this.matchMobile()).and(this.matchInsitu());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Specification<DatasetEntity> isPublic() {
        return Specification.where(this.hasFeature()).and(this.isNotDeleted()).and(this.isEnabled()).and(this.isPublished());
    }

    protected Specification<DatasetEntity> hasFeature() {
        return (Specification & Serializable)(root, query, builder) -> builder.isNotNull((Expression)root.get("feature"));
    }

    public Specification<DatasetEntity> isPublished() {
        return (Specification & Serializable)(root, query, builder) -> builder.isTrue((Expression)root.get("published"));
    }

    public Specification<DatasetEntity> isEnabled() {
        return (Specification & Serializable)(root, query, builder) -> builder.isFalse((Expression)root.get("disabled"));
    }

    public Specification<DatasetEntity> isDeleted() {
        return (Specification & Serializable)(root, query, builder) -> builder.isTrue((Expression)root.get("deleted"));
    }

    public Specification<DatasetEntity> isNotDeleted() {
        return (Specification & Serializable)(root, query, builder) -> builder.isFalse((Expression)root.get("deleted"));
    }

    public Specification<DatasetEntity> matchInsitu() {
        String insitu = this.dbQuery.getParameters().getInsitu();
        if (insitu != null && !insitu.isEmpty()) {
            if (Boolean.parseBoolean(insitu)) {
                return (Specification & Serializable)(root, query, builder) -> builder.isTrue((Expression)root.get("insitu"));
            }
            return (Specification & Serializable)(root, query, builder) -> builder.isFalse((Expression)root.get("insitu"));
        }
        return null;
    }

    public Specification<DatasetEntity> matchMobile() {
        String mobile = this.dbQuery.getParameters().getMobile();
        if (mobile != null && !mobile.isEmpty()) {
            if (Boolean.parseBoolean(mobile)) {
                return (Specification & Serializable)(root, query, builder) -> builder.isTrue((Expression)root.get("mobile"));
            }
            return (Specification & Serializable)(root, query, builder) -> builder.isFalse((Expression)root.get("mobile"));
        }
        return null;
    }

    public Specification<DatasetEntity> matchOfferings() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchOfferings(parameters.getOfferings());
    }

    public Specification<DatasetEntity> matchOfferings(String ... ids) {
        return ids != null ? this.matchOfferings(Arrays.asList(ids)) : this.matchOfferings(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchOfferings(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("offering", JoinType.INNER);
            return this.getIdPredicate(join, ids);
        };
    }

    public Specification<DatasetEntity> matchFeatures() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchFeatures(parameters.getFeatures());
    }

    public Specification<DatasetEntity> matchFeatures(String ... ids) {
        return ids != null ? this.matchFeatures(Arrays.asList(ids)) : this.matchFeatures(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchFeatures(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("feature", JoinType.INNER);
            return this.getIdPredicate(join, ids);
        };
    }

    public Specification<DatasetEntity> matchProcedures() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchProcedures(parameters.getProcedures());
    }

    public Specification<DatasetEntity> matchProcedures(boolean all) {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchProcedures(parameters.getProcedures(), all);
    }

    public Specification<DatasetEntity> matchProcedures(String ... ids) {
        return ids != null ? this.matchProcedures(Arrays.asList(ids)) : this.matchProcedures(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchProcedures(boolean all, String ... ids) {
        return ids != null ? this.matchProcedures(Arrays.asList(ids), all) : this.matchProcedures(Collections.emptyList(), all);
    }

    public Specification<DatasetEntity> matchProcedures(Collection<String> ids) {
        return this.matchProcedures(ids, false);
    }

    public Specification<DatasetEntity> matchProcedures(Collection<String> ids, boolean all) {
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("procedure", JoinType.INNER);
            if (all) {
                if (ids == null || ids.isEmpty()) {
                    return null;
                }
                return this.getIdPredicate(join, ids);
            }
            Predicate predicate = builder.isFalse((Expression)join.get("reference"));
            if (ids != null && !ids.isEmpty()) {
                return builder.and((Expression)predicate, (Expression)this.getIdPredicate(join, ids));
            }
            return predicate;
        };
    }

    public Specification<DatasetEntity> matchPhenomena() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchPhenomena(parameters.getPhenomena());
    }

    public Specification<DatasetEntity> matchPhenomena(String ... ids) {
        return ids != null ? this.matchPhenomena(Arrays.asList(ids)) : this.matchPhenomena(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchPhenomena(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("phenomenon", JoinType.INNER);
            return this.getIdPredicate(join, ids);
        };
    }

    public Specification<DatasetEntity> matchCategory() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchCategory(parameters.getCategories());
    }

    public Specification<DatasetEntity> matchCategory(String ... ids) {
        return ids != null ? this.matchCategory(Arrays.asList(ids)) : this.matchCategory(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchCategory(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("category", JoinType.INNER);
            return this.getIdPredicate(join, ids);
        };
    }

    public Specification<DatasetEntity> matchTag() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchTag(parameters.getTags());
    }

    public Specification<DatasetEntity> matchTag(String ... ids) {
        return ids != null ? this.matchTag(Arrays.asList(ids)) : this.matchTag(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchTag(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("tags", JoinType.INNER);
            return this.getIdPredicate(join, ids);
        };
    }

    public Specification<DatasetEntity> matchPlatforms() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchPlatforms(parameters.getPlatforms());
    }

    public Specification<DatasetEntity> matchPlatforms(String ... ids) {
        return ids != null ? this.matchPlatforms(Arrays.asList(ids)) : this.matchPlatforms(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchPlatforms(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("platform", JoinType.INNER);
            return this.getIdPredicate(join, ids);
        };
    }

    public Specification<DatasetEntity> matchServices() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchServices(parameters.getServices());
    }

    public Specification<DatasetEntity> matchServices(String ... ids) {
        return ids != null ? this.matchServices(Arrays.asList(ids)) : this.matchServices(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchServices(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("service", JoinType.INNER);
            return this.getIdPredicate(join, ids);
        };
    }

    public Specification<DatasetEntity> matchDatasetTypes() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchDatasetTypes(parameters.getDatasetTypes());
    }

    public Specification<DatasetEntity> matchDatasetTypes(String ... datasetTypes) {
        return datasetTypes != null ? this.matchDatasetTypes(Arrays.asList(datasetTypes)) : this.matchDatasetTypes(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchDatasetTypes(Collection<String> datasetTypes) {
        return (Specification & Serializable)(root, query, builder) -> {
            if (datasetTypes == null || datasetTypes.isEmpty()) {
                return builder.notEqual((Expression)root.get("datasetType"), (Object)DatasetType.not_initialized);
            }
            return root.get("datasetType").in((Collection)DatasetType.convert((Collection)datasetTypes));
        };
    }

    public Specification<DatasetEntity> matchObservationTypes() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchObservationTypes(parameters.getObservationTypes());
    }

    public Specification<DatasetEntity> matchObservationTypes(String ... observationTypes) {
        return observationTypes != null ? this.matchObservationTypes(Arrays.asList(observationTypes)) : this.matchObservationTypes(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchObservationTypes(Collection<String> observationTypes) {
        return (Specification & Serializable)(root, query, builder) -> {
            if (observationTypes == null || observationTypes.isEmpty()) {
                return builder.notEqual((Expression)root.get("observationType"), (Object)ObservationType.not_initialized);
            }
            return root.get("observationType").in((Collection)ObservationType.convert((Collection)observationTypes));
        };
    }

    public Specification<DatasetEntity> matchValueTypes() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchValueTypes(parameters.getValueTypes());
    }

    public Specification<DatasetEntity> matchValueTypes(String ... valueTypes) {
        return valueTypes != null ? this.matchValueTypes(Arrays.asList(valueTypes)) : this.matchValueTypes(Collections.emptyList());
    }

    public Specification<DatasetEntity> matchValueTypes(Collection<String> valueTypes) {
        return (Specification & Serializable)(root, query, builder) -> {
            if (valueTypes == null || valueTypes.isEmpty()) {
                return builder.notEqual((Expression)root.get("valueType"), (Object)ValueType.not_initialized);
            }
            return root.get("valueType").in((Collection)ValueType.convert((Collection)valueTypes));
        };
    }

    public Specification<DatasetEntity> matchId(String id) {
        return (Specification & Serializable)(root, query, builder) -> {
            if (id == null || id.isEmpty()) {
                return builder.isNull((Expression)root.get("id"));
            }
            return builder.equal((Expression)root.get("id"), (Object)Long.parseLong(id));
        };
    }

    public Specification<DatasetEntity> matchIds(Collection<String> ids) {
        return (Specification & Serializable)(root, query, builder) -> {
            if (ids != null && !ids.isEmpty()) {
                return root.get("id").in(QueryUtils.parseToIds(ids));
            }
            return null;
        };
    }

    public Specification<DatasetEntity> matchesSpatially() {
        Geometry geometry = this.dbQuery.getSpatialFilter();
        if (geometry == null || geometry.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("feature", JoinType.INNER);
            return new IntersectsPredicate((CriteriaBuilderImpl)builder, (Expression<Geometry>)join.get("geometryEntity").get("geometry"), (Expression<Geometry>)new LiteralExpression((CriteriaBuilderImpl)builder, (Object)geometry), this.entityManager);
        };
    }
}

