/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.repositories.core;

import java.util.List;
import java.util.Set;
import org.n52.sensorweb.server.db.repositories.ParameterServiceRepository;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.ServiceEntity;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public interface DatasetRepository
extends ParameterServiceRepository<DatasetEntity> {
    @Override
    default public List<DatasetEntity> findByService(ServiceEntity service) {
        return this.findAll(this.createExample(new DatasetEntity(), this.createMatcher()));
    }

    public void deleteByIdIn(Iterable<Long> var1);

    @Override
    default public ExampleMatcher createMatcher() {
        return ExampleMatcher.matching().withIgnorePaths(new String[]{"id"}).withMatcher("service", ExampleMatcher.GenericPropertyMatchers.ignoreCase());
    }

    @Query(value="SELECT dataset_id, dataset_type, observation_type, value_type FROM {h-schema}dataset WHERE dataset_id in (?1)", nativeQuery=true)
    public Set<Object[]> getMetadataTypes(Set<Long> var1);
}

