/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.math.BigInteger;
import java.util.Date;
import java.util.Objects;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.SimpleProjection;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.Type;

public class MoreProjections {
    public <T, X extends Type & LiteralType<T>> Projection constant(T value, X type) {
        return new ConstantProjection<T, X>(value, type);
    }

    public Projection constant(String value) {
        return this.constant(value, StringType.INSTANCE);
    }

    public Projection constant(boolean value) {
        return this.constant(value, TrueFalseType.INSTANCE);
    }

    public Projection constant(double value) {
        return this.constant(value, DoubleType.INSTANCE);
    }

    public Projection constant(float value) {
        return this.constant(Float.valueOf(value), FloatType.INSTANCE);
    }

    public Projection constant(long value) {
        return this.constant(value, LongType.INSTANCE);
    }

    public Projection constant(int value) {
        return this.constant(value, IntegerType.INSTANCE);
    }

    public Projection constant(short value) {
        return this.constant(value, ShortType.INSTANCE);
    }

    public Projection constant(byte value) {
        return this.constant(value, ByteType.INSTANCE);
    }

    public Projection constant(char value) {
        return this.constant(Character.valueOf(value), CharacterType.INSTANCE);
    }

    public Projection constant(Date value) {
        return this.constant(value, DateType.INSTANCE);
    }

    public Projection constant(BigInteger value) {
        return this.constant(value, BigIntegerType.INSTANCE);
    }

    private static class ConstantProjection<T, X extends Type & LiteralType<T>>
    extends SimpleProjection {
        private static final long serialVersionUID = -754276448432073689L;
        private final X type;
        private final T value;

        ConstantProjection(T value, X type) {
            this.type = (Type)Objects.requireNonNull(type);
            this.value = value;
        }

        public String toSqlString(Criteria criteria, int position, CriteriaQuery criteriaQuery) {
            try {
                Dialect dialect = criteriaQuery.getFactory().getDialect();
                StringBuilder buf = new StringBuilder();
                if (this.value == null) {
                    buf.append("null");
                } else {
                    buf.append(((LiteralType)this.type).objectToSQLString(this.value, dialect));
                }
                return buf.append(" as y").append(position).append("_").toString();
            }
            catch (Exception ex) {
                throw new HibernateException((Throwable)ex);
            }
        }

        public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) {
            return new Type[]{this.type};
        }
    }
}

