/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.query;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.expression.LiteralExpression;
import org.locationtech.jts.geom.Geometry;
import org.n52.io.request.IoParameters;
import org.n52.sensorweb.server.db.old.dao.DbQuery;
import org.n52.sensorweb.server.db.query.IntersectsPredicate;
import org.n52.sensorweb.server.db.query.QuerySpecifications;
import org.n52.series.db.beans.DataEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.springframework.data.jpa.domain.Specification;

public final class DataQuerySpecifications<E extends DatasetEntity>
extends QuerySpecifications {
    private DataQuerySpecifications(DbQuery query) {
        super(query, null);
    }

    public static <E> DataQuerySpecifications of(DbQuery query) {
        return new DataQuerySpecifications<E>(query);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Specification<DataEntity> matchFilters() {
        return this.matchDatasets().and(this.matchTimespan()).and(this.matchParentsIsNull()).and(this.matchesSpatially());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Specification<DataEntity> matchFiltersParentsNotNull() {
        return this.matchDatasets().and(this.matchTimespan()).and(this.matchParentsIsNotNull()).and(this.matchesSpatially());
    }

    private Specification<DataEntity> matchTimespan() {
        return (Specification & Serializable)(root, query, builder) -> {
            Date requestedStart = this.getTimespanStart();
            Date requestedEnd = this.getTimespanEnd();
            return builder.and((Expression)builder.greaterThanOrEqualTo((Expression)root.get("samplingTimeStart"), (Comparable)requestedStart), (Expression)builder.lessThanOrEqualTo((Expression)root.get("samplingTimeEnd"), (Comparable)requestedEnd));
        };
    }

    public Specification<DataEntity> matchParentsIsNull() {
        return (Specification & Serializable)(root, query, builder) -> builder.isNull((Expression)root.get("parent"));
    }

    public Specification<DataEntity> matchParentsIsNotNull() {
        return (Specification & Serializable)(root, query, builder) -> builder.isNotNull((Expression)root.get("parent"));
    }

    public Specification<DataEntity> matchDatasets() {
        IoParameters parameters = this.dbQuery.getParameters();
        return this.matchDatasets(parameters.getDatasets());
    }

    public Specification<DataEntity> matchDatasets(String ... ids) {
        return ids != null ? this.matchDatasets(Arrays.asList(ids)) : this.matchDatasets(Collections.emptyList());
    }

    private Specification<DataEntity> matchDatasets(Long id) {
        return id != null ? this.matchDatasets(Arrays.asList(Long.toString(id))) : this.matchDatasets(Collections.emptyList());
    }

    public Specification<DataEntity> matchDatasets(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> {
            Join join = root.join("dataset", JoinType.INNER);
            return this.getIdPredicate(join, ids);
        };
    }

    public Optional<DataEntity> matchStart(DatasetEntity dataset, EntityManager entityManager) {
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DataEntity.class);
        Root root = query.from(DataEntity.class);
        query.select((Selection)root).orderBy(new Order[]{builder.desc((Expression)root.get("samplingTimeEnd"))}).where(new Predicate[]{this.matchDatasets(dataset.getId()).toPredicate(root, query, builder), this.matcheEquals(this.getTimespanStart(), "samplingTimeStart").toPredicate(root, query, builder)});
        return entityManager.createQuery(query).setMaxResults(1).getResultList().stream().findFirst();
    }

    public Optional<DataEntity> matchEnd(DatasetEntity dataset, EntityManager entityManager) {
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DataEntity.class);
        Root root = query.from(DataEntity.class);
        query.select((Selection)root).orderBy(new Order[]{builder.desc((Expression)root.get("samplingTimeEnd"))}).where(new Predicate[]{this.matchDatasets(dataset.getId()).toPredicate(root, query, builder), this.matcheEquals(this.getTimespanEnd(), "samplingTimeEnd").toPredicate(root, query, builder)});
        return entityManager.createQuery(query).setMaxResults(1).getResultList().stream().findFirst();
    }

    public Optional<DataEntity> matchClosestBeforeStart(DatasetEntity dataset, EntityManager entityManager) {
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DataEntity.class);
        Root root = query.from(DataEntity.class);
        query.select((Selection)root).orderBy(new Order[]{builder.desc((Expression)root.get("samplingTimeEnd"))}).where(new Predicate[]{this.matchDatasets(dataset.getId()).toPredicate(root, query, builder), this.matchBefore(this.getTimespanStart()).toPredicate(root, query, builder)});
        return entityManager.createQuery(query).setMaxResults(1).getResultList().stream().findFirst();
    }

    public Optional<DataEntity> matchClosestAfterEnd(DatasetEntity dataset, EntityManager entityManager) {
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DataEntity.class);
        Root root = query.from(DataEntity.class);
        query.select((Selection)root).orderBy(new Order[]{builder.asc((Expression)root.get("samplingTimeEnd"))}).where(new Predicate[]{this.matchDatasets(dataset.getId()).toPredicate(root, query, builder), this.matchAfter(this.getTimespanEnd()).toPredicate(root, query, builder)});
        return entityManager.createQuery(query).setMaxResults(1).getResultList().stream().findFirst();
    }

    public Long count(DatasetEntity dataset, EntityManager entityManager) {
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root root = query.from(DataEntity.class);
        query.select((Selection)builder.count((Expression)root));
        query.where((Expression)this.matchDatasets(dataset.getId()).toPredicate(root, query, builder));
        return (Long)entityManager.createQuery(query).getSingleResult();
    }

    public DataEntity min(DatasetEntity dataset, EntityManager entityManager) {
        return null;
    }

    public DataEntity max(DatasetEntity dataset, EntityManager entityManager) {
        return null;
    }

    public BigDecimal average(DatasetEntity dataset, EntityManager entityManager) {
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Double.class);
        Root root = query.from(DataEntity.class);
        query.select((Selection)builder.avg((Expression)root.get("value")));
        query.where((Expression)this.matchDatasets(dataset.getId()).toPredicate(root, query, builder));
        return BigDecimal.valueOf((Double)entityManager.createQuery(query).getSingleResult());
    }

    private Specification<DataEntity> matcheEquals(Date date, String property) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.get(property), (Object)date);
    }

    private Specification<DataEntity> matchBefore(Date date) {
        return (Specification & Serializable)(root, query, builder) -> builder.lessThan((Expression)root.get("samplingTimeStart"), (Comparable)date);
    }

    private Specification<DataEntity> matchAfter(Date date) {
        return (Specification & Serializable)(root, query, builder) -> builder.greaterThan((Expression)root.get("samplingTimeEnd"), (Comparable)date);
    }

    public Specification<DataEntity> matchesSpatially() {
        Geometry geometry = this.dbQuery.getSpatialFilter();
        if (geometry == null || geometry.isEmpty()) {
            return null;
        }
        return (Specification & Serializable)(root, query, builder) -> new IntersectsPredicate((CriteriaBuilderImpl)builder, (Expression<Geometry>)root.get("geometryEntity").get("geometry"), (Expression<Geometry>)new LiteralExpression((CriteriaBuilderImpl)builder, (Object)geometry), this.entityManager);
    }
}

