/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.old.dao;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyProjection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class QueryUtils {
    public static String createAssociation(String alias, String property) {
        return alias != null && !alias.isEmpty() ? alias + "." + property : property;
    }

    public static DetachedCriteria projectionOnPkid(DetachedCriteria criteria) {
        return QueryUtils.projectionOnPkid(null, criteria);
    }

    public static DetachedCriteria projectionOnPkid(String member, DetachedCriteria criteria) {
        return QueryUtils.projectionOnPkid(null, member, criteria);
    }

    public static DetachedCriteria projectionOnPkid(String alias, String member, DetachedCriteria criteria) {
        return criteria.setProjection((Projection)QueryUtils.projectionOnPkid(alias, member));
    }

    public static PropertyProjection projectionOnPkid() {
        return QueryUtils.projectionOnPkid((String)null);
    }

    public static PropertyProjection projectionOnPkid(String member) {
        return QueryUtils.projectionOnPkid(null, member);
    }

    public static PropertyProjection projectionOnPkid(String alias, String member) {
        return QueryUtils.projectionOn(alias, member, "id");
    }

    public static DetachedCriteria projectionOn(String property, DetachedCriteria criteria) {
        return QueryUtils.projectionOn(null, property, criteria);
    }

    public static DetachedCriteria projectionOn(String member, String property, DetachedCriteria criteria) {
        return QueryUtils.projectionOn(null, member, property, criteria);
    }

    public static DetachedCriteria projectionOn(String alias, String member, String property, DetachedCriteria criteria) {
        return criteria.setProjection((Projection)QueryUtils.projectionOn(alias, member, property));
    }

    public static PropertyProjection projectionOn(String property) {
        return QueryUtils.projectionOn(null, property);
    }

    public static PropertyProjection projectionOn(String member, String property) {
        return QueryUtils.projectionOn(null, member, property);
    }

    public static PropertyProjection projectionOn(String alias, String member, String property) {
        String qMember = QueryUtils.createAssociation(alias, member);
        String association = QueryUtils.createAssociation(qMember, property);
        return Projections.property((String)association);
    }

    public static void setFilterProjectionOn(String parameter, DetachedCriteria c) {
        if (!parameter.isEmpty()) {
            QueryUtils.projectionOn(parameter, c);
        } else {
            QueryUtils.projectionOnPkid(c);
        }
    }

    public static Set<Long> parseToIds(Collection<String> ids) {
        return ids.stream().map(e -> QueryUtils.parseToId(e)).collect(Collectors.toSet());
    }

    public static SimpleExpression matchesPkid(String id) {
        return Restrictions.eq((String)"id", (Object)QueryUtils.parseToId(id));
    }

    public static Long parseToId(String id) {
        try {
            String rawId = id.substring(id.lastIndexOf("_") + 1);
            return Long.parseLong(rawId);
        }
        catch (NumberFormatException e) {
            return Long.MIN_VALUE;
        }
    }
}

