/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db.old.dao;

import java.util.Objects;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.io.request.IoParameters;
import org.n52.sensorweb.server.db.old.dao.DbQuery;
import org.n52.sensorweb.server.db.old.dao.DbQueryFactory;

@Configurable
public class DefaultDbQueryFactory
implements DbQueryFactory {
    private static final String STORAGE_EPSG_KEY = "service.defaultEpsg";
    private static final String EPSG_PREFIX = "EPSG:";
    private String databaseSrid = "EPSG:4326";
    private Integer epsgCode;

    public DefaultDbQueryFactory() {
    }

    public DefaultDbQueryFactory(String srid) {
        Objects.requireNonNull(srid, "srid is null");
        this.databaseSrid = srid;
    }

    @Override
    public DbQuery createFrom(IoParameters parameters) {
        DbQuery query = new DbQuery(parameters);
        query.setDatabaseSridCode(this.getDatabaseSrid());
        return query;
    }

    @Override
    public String getDatabaseSrid() {
        return this.epsgCode != null && this.epsgCode > 0 ? EPSG_PREFIX.concat(this.epsgCode.toString()) : this.databaseSrid;
    }

    @Override
    public void setDatabaseSrid(String databaseSrid) {
        if (databaseSrid != null && !databaseSrid.isEmpty()) {
            this.databaseSrid = databaseSrid.startsWith(EPSG_PREFIX) ? databaseSrid : EPSG_PREFIX.concat(databaseSrid);
        }
    }

    @Setting(value="service.defaultEpsg")
    public void setStorageEpsg(int epsgCode) {
        this.epsgCode = epsgCode;
    }
}

