/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.HibernateCollectors;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.LikeExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public final class MoreRestrictions {
    private static final char DEF_ESC_CHR = '\\';
    private static final String DEF_ESC_STR = "\\";

    private MoreRestrictions() {
    }

    public static LikeExpression ilike(String propertyName, String value, Character escapeChar) {
        return MoreRestrictions.like(propertyName, value, escapeChar, true);
    }

    public static LikeExpression ilike(String propertyName, String value, String escapeString) {
        return MoreRestrictions.like(propertyName, value, escapeString, true);
    }

    public static LikeExpression ilike(String propertyName, String value, MatchMode matchMode, Character escapeChar) {
        return MoreRestrictions.like(propertyName, value, matchMode, escapeChar, true);
    }

    public static LikeExpression ilike(String propertyName, String value, MatchMode matchMode, String escapeString) {
        return MoreRestrictions.like(propertyName, value, matchMode, escapeString, true);
    }

    public static LikeExpression like(String propertyName, String value, Character escapeChar, boolean ignoreCase) {
        return new LikeExpression(propertyName, value, escapeChar, ignoreCase);
    }

    public static LikeExpression like(String propertyName, String value, String escapeString, boolean ignoreCase) {
        if (escapeString != null) {
            if (escapeString.length() > 1) {
                return MoreRestrictions.like(propertyName, MoreRestrictions.normalize(escapeString, value), Character.valueOf('\\'), ignoreCase);
            }
            return MoreRestrictions.like(propertyName, value, Character.valueOf(escapeString.charAt(0)), ignoreCase);
        }
        return MoreRestrictions.like(propertyName, value, (Character)null, ignoreCase);
    }

    public static LikeExpression like(String propertyName, String value) {
        return new LikeExpression(propertyName, value);
    }

    public static LikeExpression like(String propertyName, String value, MatchMode matchMode) {
        return new LikeExpression(propertyName, value, matchMode);
    }

    public static LikeExpression like(String propertyName, String value, MatchMode matchMode, String escapeString, boolean ignoreCase) {
        if (escapeString != null) {
            if (escapeString.length() > 1) {
                return MoreRestrictions.like(propertyName, MoreRestrictions.normalize(escapeString, value), matchMode, Character.valueOf('\\'), ignoreCase);
            }
            return MoreRestrictions.like(propertyName, value, matchMode, Character.valueOf(escapeString.charAt(0)), ignoreCase);
        }
        return MoreRestrictions.like(propertyName, value, matchMode, (Character)null, ignoreCase);
    }

    public static LikeExpression like(String propertyName, String value, MatchMode matchMode, Character escapeChar, boolean ignoreCase) {
        return new LikeExpression(propertyName, value, matchMode, escapeChar, ignoreCase);
    }

    private static String normalize(String escapeString, String value) {
        return Pattern.compile(escapeString, 16).matcher(value.replaceAll("\\\\", "\\\\")).replaceAll(DEF_ESC_STR);
    }

    public static Criterion alwaysFalse() {
        return Restrictions.sqlRestriction((String)"0=1");
    }

    public static Criterion alwaysTrue() {
        return Restrictions.sqlRestriction((String)"1=1");
    }

    public static Collector<Criterion, ?, Criterion> toDisjunction() {
        return MoreRestrictions.toCriterion(Restrictions::disjunction);
    }

    public static Collector<Criterion, ?, Criterion> toConjunction() {
        return MoreRestrictions.toCriterion(Restrictions::conjunction);
    }

    private static Collector<Criterion, ?, Criterion> toCriterion(Function<Criterion[], Criterion> finisher) {
        return Collectors.collectingAndThen(Collectors.collectingAndThen(Collectors.toSet(), s -> (Criterion[])s.stream().toArray(Criterion[]::new)), finisher);
    }

    @SafeVarargs
    public static Optional<? extends Criterion> and(Optional<? extends Criterion> ... criteria) {
        Conjunction conjunction = Arrays.stream(criteria).filter(Optional::isPresent).map(optional -> (Criterion)optional.get()).collect(HibernateCollectors.toConjunction());
        return Optional.of(conjunction).filter(MoreRestrictions::hasConditions);
    }

    @SafeVarargs
    public static Optional<? extends Criterion> or(Optional<? extends Criterion> ... criteria) {
        Disjunction disjunction = Arrays.stream(criteria).filter(Optional::isPresent).map(optional -> (Criterion)optional.get()).collect(HibernateCollectors.toDisjunction());
        return Optional.of(disjunction).filter(MoreRestrictions::hasConditions);
    }

    public static boolean hasConditions(Junction j) {
        return j.conditions().iterator().hasNext();
    }
}

