/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db;

import java.io.IOException;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.n52.sensorweb.server.db.TestRepositories;
import org.n52.sensorweb.server.db.factory.HibernatePersistenceLoadingLocalContainerEntityManagerFactoryBean;
import org.n52.series.db.beans.DatasetEntity;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public abstract class TestRepositoryConfig<T extends DatasetEntity> {
    private final String xmlPersistenceLocation;

    public TestRepositoryConfig(String xmlPersistenceLocation) {
        this.xmlPersistenceLocation = xmlPersistenceLocation;
    }

    @Bean
    public abstract TestRepositories testRepositories();

    @Bean
    public EntityManagerFactory entityManagerFactory(DataSource datasource, JpaProperties properties) throws IOException {
        LocalContainerEntityManagerFactoryBean emf = this.createEntityManagerFactoryBean(datasource, properties, this.xmlPersistenceLocation);
        return emf.getNativeEntityManagerFactory();
    }

    private LocalContainerEntityManagerFactoryBean createEntityManagerFactoryBean(DataSource datasource, JpaProperties properties, String xmlPersistenceLocation) {
        return new HibernatePersistenceLoadingLocalContainerEntityManagerFactoryBean(datasource, properties, xmlPersistenceLocation);
    }
}

