/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.test;

import java.util.UUID;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.n52.series.db.beans.dataset.DatasetType;
import org.n52.series.db.beans.dataset.ObservationType;
import org.n52.series.db.beans.dataset.ValueType;

public class DatasetEntityBuilder {
    private PhenomenonEntity phenomenon;
    private ProcedureEntity procedure;
    private OfferingEntity offering;
    private CategoryEntity category;

    private DatasetEntityBuilder() {
    }

    public <T extends DatasetEntity> T build(T entity) {
        entity.setOffering(this.offering);
        entity.setProcedure(this.procedure);
        entity.setPhenomenon(this.phenomenon);
        entity.setCategory(this.category);
        entity.setDatasetType(entity.getDatasetType() != null ? entity.getDatasetType() : DatasetType.not_initialized);
        entity.setObservationType(entity.getObservationType() != null ? entity.getObservationType() : ObservationType.not_initialized);
        entity.setValueType(entity.getValueType() != null ? entity.getValueType() : ValueType.not_initialized);
        entity.setStaIdentifier(UUID.randomUUID().toString());
        return entity;
    }

    public static DatasetEntityBuilder newDataset() {
        DatasetEntityBuilder builder = new DatasetEntityBuilder();
        return builder;
    }

    public DatasetEntityBuilder setOffering(OfferingEntity entity) {
        this.offering = entity;
        return this;
    }

    public DatasetEntityBuilder setProcedure(ProcedureEntity entity) {
        this.procedure = entity;
        return this;
    }

    public DatasetEntityBuilder setPhenomemon(PhenomenonEntity entity) {
        this.phenomenon = entity;
        return this;
    }

    public DatasetEntityBuilder setCategory(CategoryEntity entity) {
        this.category = entity;
        return this;
    }
}

