/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db;

import org.n52.sensorweb.server.db.repositories.core.CategoryRepository;
import org.n52.sensorweb.server.db.repositories.core.DatasetRepository;
import org.n52.sensorweb.server.db.repositories.core.FeatureRepository;
import org.n52.sensorweb.server.db.repositories.core.FormatRepository;
import org.n52.sensorweb.server.db.repositories.core.OfferingRepository;
import org.n52.sensorweb.server.db.repositories.core.PhenomenonRepository;
import org.n52.sensorweb.server.db.repositories.core.ProcedureRepository;
import org.n52.sensorweb.server.test.CategoryBuilder;
import org.n52.sensorweb.server.test.DatasetEntityBuilder;
import org.n52.sensorweb.server.test.FeatureBuilder;
import org.n52.sensorweb.server.test.FormatBuilder;
import org.n52.sensorweb.server.test.OfferingBuilder;
import org.n52.sensorweb.server.test.PhenomenonBuilder;
import org.n52.sensorweb.server.test.ProcedureBuilder;
import org.n52.series.db.beans.AbstractFeatureEntity;
import org.n52.series.db.beans.CategoryEntity;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.FeatureEntity;
import org.n52.series.db.beans.FormatEntity;
import org.n52.series.db.beans.OfferingEntity;
import org.n52.series.db.beans.PhenomenonEntity;
import org.n52.series.db.beans.ProcedureEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestRepositories {
    @Autowired
    private PhenomenonRepository phenomenonRepository;
    @Autowired
    private FeatureRepository featureRepository;
    @Autowired
    private OfferingRepository offeringRepository;
    @Autowired
    private ProcedureRepository procedureRepository;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private FormatRepository formatRepository;
    @Autowired
    private DatasetRepository datasetRepository;

    public <T extends DatasetEntity> T persistSimpleDataset(String phenomenonIdentifier, String offeringIdentifier, String procedureIdentifier, String procedureFormat, T emptyDatasetEntity) {
        T dataset = this.buildNewDataset(procedureFormat, procedureIdentifier, phenomenonIdentifier, offeringIdentifier, emptyDatasetEntity);
        return this.save(dataset);
    }

    public <T extends DatasetEntity> T persistSimpleDataset(String phenomenonIdentifier, String offeringIdentifier, String procedureIdentifier, String procedureFormat, String featureIdentifier, String featureFormat, T emptyDatasetEntity) {
        T dataset = this.buildNewDataset(procedureFormat, procedureIdentifier, phenomenonIdentifier, offeringIdentifier, emptyDatasetEntity);
        dataset.setFeature(this.upsertSimpleFeature(featureIdentifier, featureFormat));
        return this.save(dataset);
    }

    private <T extends DatasetEntity> T buildNewDataset(String procedureFormat, String procedureIdentifier, String phenomenonIdentifier, String offeringIdentifier, T emptyDatasetEntity) {
        return DatasetEntityBuilder.newDataset().setOffering(this.upsertSimpleOffering(offeringIdentifier)).setPhenomemon(this.upsertSimplePhenomenon(phenomenonIdentifier)).setProcedure(this.upsertSimpleProcedure(procedureIdentifier, procedureFormat)).setCategory(this.upsertSimpleCategory(phenomenonIdentifier)).build(emptyDatasetEntity);
    }

    public ProcedureEntity upsertSimpleProcedure(String procedureIdentifier, String format) {
        return this.procedureRepository.findByIdentifier(procedureIdentifier).orElseGet(() -> this.persistSimpleProcedure(procedureIdentifier, format));
    }

    public ProcedureEntity persistSimpleProcedure(String procedureIdentifier, String format) {
        FormatEntity formatEntity = this.upsertFormat(format);
        ProcedureBuilder builder = ProcedureBuilder.newProcedure(procedureIdentifier);
        ProcedureEntity entity = builder.setFormat(formatEntity).build();
        return this.save(entity);
    }

    public PhenomenonEntity upsertSimplePhenomenon(String phenomenonIdentifier) {
        return this.phenomenonRepository.findByIdentifier(phenomenonIdentifier).orElseGet(() -> this.persistSimplePhenomenon(phenomenonIdentifier));
    }

    public PhenomenonEntity persistSimplePhenomenon(String phenomenonIdentifier) {
        return this.save(PhenomenonBuilder.newPhenomenon(phenomenonIdentifier).build());
    }

    public CategoryEntity upsertSimpleCategory(String categoryIdentifier) {
        return this.categoryRepository.findByIdentifier(categoryIdentifier).orElseGet(() -> this.persistSimpleCategory(categoryIdentifier));
    }

    public CategoryEntity persistSimpleCategory(String categoryIdentifier) {
        return this.save(CategoryBuilder.newCategory(categoryIdentifier).build());
    }

    public AbstractFeatureEntity upsertSimpleFeature(String featureIdentifier, String format) {
        return this.featureRepository.findByIdentifier(featureIdentifier).orElseGet(() -> this.persistSimpleFeature(featureIdentifier, format));
    }

    public FeatureEntity persistSimpleFeature(String featureIdentifier, String format) {
        FormatEntity formatEntity = this.upsertFormat(format);
        FeatureBuilder builder = FeatureBuilder.newFeature(featureIdentifier);
        FeatureEntity entity = builder.setFormat(formatEntity).build();
        return this.save(entity);
    }

    public FormatEntity upsertFormat(String format) {
        return this.formatRepository.existsByFormat(format) ? this.formatRepository.findByFormat(format) : this.save(FormatBuilder.newFormat(format).build());
    }

    public OfferingEntity upsertSimpleOffering(String offeringIdentifier) {
        return this.offeringRepository.findByIdentifier(offeringIdentifier).orElseGet(() -> this.persistSimpleOffering(offeringIdentifier));
    }

    public OfferingEntity persistSimpleOffering(String offeringIdentifier) {
        return this.save(OfferingBuilder.newOffering(offeringIdentifier).build());
    }

    public PhenomenonEntity save(PhenomenonEntity entity) {
        return (PhenomenonEntity)this.phenomenonRepository.save((Object)entity);
    }

    public FeatureEntity save(FeatureEntity entity) {
        return (FeatureEntity)this.featureRepository.save((Object)entity);
    }

    public OfferingEntity save(OfferingEntity entity) {
        return (OfferingEntity)this.offeringRepository.save((Object)entity);
    }

    public ProcedureEntity save(ProcedureEntity entity) {
        return (ProcedureEntity)this.procedureRepository.saveAndFlush((Object)entity);
    }

    public CategoryEntity save(CategoryEntity entity) {
        return (CategoryEntity)this.categoryRepository.save((Object)entity);
    }

    public FormatEntity save(FormatEntity entity) {
        return (FormatEntity)this.formatRepository.save((Object)entity);
    }

    public <T extends DatasetEntity> T save(T entity) {
        return (T)((DatasetEntity)this.datasetRepository.save(entity));
    }
}

