/*
 * Decompiled with CFR 0.152.
 */
package org.n52.sensorweb.server.db;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.junit.jupiter.api.BeforeEach;
import org.n52.io.request.IoParameters;
import org.n52.sensorweb.server.db.TestRepositories;
import org.n52.sensorweb.server.db.old.dao.DbQuery;
import org.n52.sensorweb.server.db.old.dao.DefaultDbQueryFactory;
import org.n52.sensorweb.server.db.query.DatasetQuerySpecifications;
import org.n52.series.db.beans.DatasetEntity;
import org.n52.series.db.beans.dataset.DatasetType;
import org.n52.series.db.beans.dataset.ObservationType;
import org.n52.series.db.beans.dataset.ValueType;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class TestBase {
    @PersistenceContext
    protected EntityManager entityManager;
    @Autowired
    protected TestRepositories testRepositories;
    protected DatasetQuerySpecifications defaultFilterSpec;
    protected DbQuery defaultQuery;

    @BeforeEach
    public void setUp() {
        this.defaultQuery = new DefaultDbQueryFactory().createFrom(IoParameters.createDefaults());
        this.defaultFilterSpec = DatasetQuerySpecifications.of((DbQuery)this.defaultQuery, (EntityManager)this.entityManager);
    }

    protected DatasetEntity uninitializedDataset(String phenomenonIdentifier, String offeringIdentifier, String procedureIdentifier, String procedureFormat) {
        return this.testRepositories.persistSimpleDataset(phenomenonIdentifier, offeringIdentifier, procedureIdentifier, procedureFormat, new DatasetEntity());
    }

    protected DatasetEntity uninitializedDataset(String phenomenonIdentifier, String offeringIdentifier, String procedureIdentifier, String procedureFormat, String featureIdentifier, String featureFormat) {
        return this.testRepositories.persistSimpleDataset(phenomenonIdentifier, offeringIdentifier, procedureIdentifier, procedureFormat, featureIdentifier, featureFormat, new DatasetEntity());
    }

    protected DatasetEntity quantityDataset(String phenomenonIdentifier, String offeringIdentifier, String procedureIdentifier, String procedureFormat) {
        return this.testRepositories.persistSimpleDataset(phenomenonIdentifier, offeringIdentifier, procedureIdentifier, procedureFormat, new DatasetEntity(DatasetType.timeseries, ObservationType.simple, ValueType.quantity));
    }

    protected DatasetEntity quantityDataset(String phenomenonIdentifier, String offeringIdentifier, String procedureIdentifier, String procedureFormat, String featureIdentifier, String featureFormat) {
        return this.testRepositories.persistSimpleDataset(phenomenonIdentifier, offeringIdentifier, procedureIdentifier, procedureFormat, featureIdentifier, featureFormat, new DatasetEntity(DatasetType.timeseries, ObservationType.simple, ValueType.quantity));
    }

    protected DatasetEntity quantityProfileDataset(String phenomenonIdentifier, String offeringIdentifier, String procedureIdentifier, String procedureFormat, String featureIdentifier, String featureFormat) {
        return this.testRepositories.persistSimpleDataset(phenomenonIdentifier, offeringIdentifier, procedureIdentifier, procedureFormat, featureIdentifier, featureFormat, new DatasetEntity(DatasetType.timeseries, ObservationType.profile, ValueType.quantity));
    }

    protected DatasetEntity textDataset(String phenomenonIdentifier, String offeringIdentifier, String procedureIdentifier, String procedureFormat, String featureIdentifier, String featureFormat) {
        return this.testRepositories.persistSimpleDataset(phenomenonIdentifier, offeringIdentifier, procedureIdentifier, procedureFormat, featureIdentifier, featureFormat, new DatasetEntity(DatasetType.timeseries, ObservationType.simple, ValueType.text));
    }

    protected DatasetQuerySpecifications getDatasetQuerySpecification(DbQuery query) {
        return DatasetQuerySpecifications.of((DbQuery)query, (EntityManager)this.entityManager);
    }
}

