/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.statistics.impl.geolocation;

import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Singleton;
import org.elasticsearch.common.geo.GeoPoint;
import org.n52.iceland.config.annotation.Configurable;
import org.n52.iceland.config.annotation.Setting;
import org.n52.iceland.lifecycle.Constructable;
import org.n52.iceland.lifecycle.Destroyable;
import org.n52.iceland.request.RequestContext;
import org.n52.iceland.statistics.api.interfaces.geolocation.IAdminStatisticsLocation;
import org.n52.iceland.statistics.api.interfaces.geolocation.IStatisticsLocationUtil;
import org.n52.iceland.statistics.api.parameters.ObjectEsParameterFactory;
import org.n52.iceland.statistics.api.utils.FileDownloader;
import org.n52.iceland.statistics.api.utils.GeoLiteFileDownloader;
import org.n52.iceland.util.net.IPAddress;
import org.n52.iceland.util.net.ProxyChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Configurable
public class StatisticsLocationUtil
implements IStatisticsLocationUtil,
IAdminStatisticsLocation,
Constructable,
Destroyable {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsLocationUtil.class);
    private boolean enabled = false;
    private boolean isAutoDownload;
    private String downloadFolderPath;
    private String cityDbLoc;
    private String countryDbLoc;
    private IAdminStatisticsLocation.LocationDatabaseType dbType;
    private DatabaseReader reader;

    @Override
    public Map<String, Object> ip2SpatialData(IPAddress ip) {
        if (ip == null) {
            return null;
        }
        return this.ip2SpatialData(ip.asInetAddress());
    }

    @Override
    public Map<String, Object> ip2SpatialData(String host) {
        try {
            return this.ip2SpatialData(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            logger.warn("Not a valid IPv4 address", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> ip2SpatialData(InetAddress ip) {
        if (!this.enabled) {
            return null;
        }
        if (this.reader == null) {
            logger.warn("Location database is not initialized. Exiting.");
            return null;
        }
        try {
            HashMap<String, Object> holder = new HashMap<String, Object>();
            if (this.dbType == IAdminStatisticsLocation.LocationDatabaseType.COUNTRY) {
                Country country = this.reader.country(ip).getCountry();
                holder.put(ObjectEsParameterFactory.GEOLOC_COUNTRY_CODE.getName(), country.getIsoCode());
            } else {
                CityResponse city = this.reader.city(ip);
                Location loc = city.getLocation();
                holder.put(ObjectEsParameterFactory.GEOLOC_COUNTRY_CODE.getName(), city.getCountry().getIsoCode());
                holder.put(ObjectEsParameterFactory.GEOLOC_CITY_NAME.getName(), city.getCity().getName());
                holder.put(ObjectEsParameterFactory.GEOLOC_GEO_POINT.getName(), new GeoPoint(loc.getLatitude().doubleValue(), loc.getLongitude().doubleValue()));
            }
            return holder;
        }
        catch (Throwable e) {
            logger.warn("Can't convert IP to GeoIp", e);
            return null;
        }
    }

    @Override
    public IPAddress resolveOriginalIpAddress(RequestContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.getForwardedForChain().isPresent()) {
            return ((ProxyChain)ctx.getForwardedForChain().get()).getOrigin();
        }
        return (IPAddress)ctx.getIPAddress().orNull();
    }

    @Override
    public void initDatabase(IAdminStatisticsLocation.LocationDatabaseType type, String pathToDatabase) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(pathToDatabase);
        logger.info("Init {} as type {} with file {}", new Object[]{this.getClass().toString(), type.toString(), pathToDatabase});
        this.dbType = type;
        try {
            File f = new File(pathToDatabase);
            this.reader = new DatabaseReader.Builder(f).fileMode(Reader.FileMode.MEMORY_MAPPED).build();
            if (!type.getGeoLite2Name().equals(this.reader.getMetadata().getDatabaseType())) {
                logger.error("DatabaseType {} not match with the databasefile {}. Exiting.", (Object)type.toString(), (Object)pathToDatabase);
                this.destroy();
                return;
            }
        }
        catch (Throwable e) {
            logger.error("Couldn't initation geolocation database ", e);
            this.reader = null;
        }
    }

    public void destroy() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            logger.error("Error during closing GeoLite reader", (Throwable)e);
        }
        finally {
            this.enabled = false;
            this.reader = null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Setting(value="statistics.geoloc.enabled")
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAutoDownload() {
        return this.isAutoDownload;
    }

    @Setting(value="statistics.geoloc.db_downloader")
    public void setAutoDownload(String choice) {
        this.isAutoDownload = choice.equalsIgnoreCase("statistics.geoloc.db_downloader.auto");
    }

    public String getDownloadFolderPath() {
        return this.downloadFolderPath;
    }

    @Setting(value="statistics.geoloc.download_folder")
    public void setDownloadFolderPath(String downloadFolderPath) {
        this.downloadFolderPath = downloadFolderPath;
        if (this.downloadFolderPath != null) {
            while (this.downloadFolderPath.endsWith("/") || this.downloadFolderPath.endsWith("\\")) {
                this.downloadFolderPath = this.downloadFolderPath.substring(0, this.downloadFolderPath.length() + 1);
            }
        }
    }

    public String getCityDbLoc() {
        return this.cityDbLoc;
    }

    @Setting(value="statistics.geoloc.city_location")
    public void setCityDbLoc(String cityDbLoc) {
        this.cityDbLoc = cityDbLoc;
    }

    public String getCountryDbLoc() {
        return this.countryDbLoc;
    }

    @Setting(value="statistics.geoloc.country_location")
    public void setCountryDbLoc(String countryDbLoc) {
        this.countryDbLoc = countryDbLoc;
    }

    public IAdminStatisticsLocation.LocationDatabaseType getDbType() {
        return this.dbType;
    }

    @Setting(value="statistics.geoloc.db_type")
    public void setDbType(String dbType) {
        this.dbType = dbType.equalsIgnoreCase("statistics.geoloc.db_type.city") ? IAdminStatisticsLocation.LocationDatabaseType.CITY : IAdminStatisticsLocation.LocationDatabaseType.COUNTRY;
    }

    public void init() {
        logger.info("Statistics Geolocation module is {}", (Object)this.enabled);
        if (this.enabled) {
            if (this.isAutoDownload) {
                String countryPath = this.downloadFolderPath + "/" + "country.mmdb";
                String cityPath = this.downloadFolderPath + "/" + "city.mmdb";
                if (!FileDownloader.isPathExists((String)countryPath) || !FileDownloader.isPathExists((String)cityPath)) {
                    GeoLiteFileDownloader.downloadDefaultDatabases((String)this.downloadFolderPath);
                } else {
                    logger.info("GeoLite2 databases on paths {} and {} already exists", (Object)countryPath, (Object)cityPath);
                }
            }
            String pathToDatabase = null;
            pathToDatabase = this.dbType == IAdminStatisticsLocation.LocationDatabaseType.CITY ? (this.isAutoDownload ? this.downloadFolderPath + "/" + "city.mmdb" : this.cityDbLoc) : (this.isAutoDownload ? this.downloadFolderPath + "/" + "country.mmdb" : this.countryDbLoc);
            if (pathToDatabase == null) {
                logger.error("Path to type {} database can't be empty. Check your location database type or the path", (Object)this.dbType.name());
                return;
            }
            this.initDatabase(this.dbType, pathToDatabase);
        }
    }
}

