/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util.action;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.n52.iceland.util.action.CompositeAction;
import org.n52.iceland.util.action.ThreadableAction;
import org.n52.janmayen.GroupedAndNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompositeParallelAction<A extends ThreadableAction>
extends CompositeAction<A> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeParallelAction.class);
    private final ThreadFactory threadFactory;
    private final ExecutorService executor;
    private final String threadGroupName;
    private CountDownLatch countDownLatch;

    @SafeVarargs
    public CompositeParallelAction(int threads, String threadGroupName, A ... actions) {
        super(actions);
        this.threadGroupName = threadGroupName;
        this.threadFactory = new GroupedAndNamedThreadFactory(threadGroupName);
        this.executor = Executors.newFixedThreadPool(threads, this.threadFactory);
    }

    @Override
    public void execute() {
        if (this.getActions() != null) {
            LOGGER.debug("Executing parallel actions");
            this.countDownLatch = new CountDownLatch(this.getActions().size());
            this.getActions().stream().forEachOrdered(action -> {
                action.setParentCountDownLatch(this.countDownLatch);
                this.pre(action);
                this.executor.submit((Runnable)action);
            });
            long latchSize = this.countDownLatch.getCount();
            this.executor.shutdown();
            try {
                LOGGER.debug("{}: waiting for {} threads to finish", (Object)this.threadGroupName, (Object)latchSize);
                this.countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOGGER.debug("Waiting for {} threads to finish", (Object)this.countDownLatch.getCount());
            this.getActions().forEach(this::post);
        }
    }
}

