/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.ogc.ows.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.iceland.ogc.ows.extension.OwsCapabilitiesExtensionKey;
import org.n52.iceland.ogc.ows.extension.OwsCapabilitiesExtensionProvider;
import org.n52.iceland.ogc.ows.extension.OwsCapabilitiesExtensionProviderFactory;
import org.n52.iceland.request.operator.RequestOperatorKey;
import org.n52.iceland.request.operator.RequestOperatorRepository;
import org.n52.janmayen.Producer;
import org.n52.janmayen.component.AbstractComponentRepository;
import org.n52.janmayen.function.Suppliers;
import org.n52.janmayen.lifecycle.Constructable;

public class OwsCapabilitiesExtensionRepository
extends AbstractComponentRepository<OwsCapabilitiesExtensionKey, OwsCapabilitiesExtensionProvider, OwsCapabilitiesExtensionProviderFactory>
implements Constructable {
    @Inject
    private RequestOperatorRepository requestOperatorRepository;
    private final Map<OwsCapabilitiesExtensionKey, Set<Producer<OwsCapabilitiesExtensionProvider>>> providers = new HashMap<OwsCapabilitiesExtensionKey, Set<Producer<OwsCapabilitiesExtensionProvider>>>();
    @Inject
    private Optional<Collection<OwsCapabilitiesExtensionProvider>> components = Optional.of(Collections.emptyList());
    @Inject
    private Optional<Collection<OwsCapabilitiesExtensionProviderFactory>> componentFactories = Optional.of(Collections.emptyList());

    public void init() {
        Map implementations = this.getProviders(this.components, this.componentFactories);
        this.providers.clear();
        implementations.forEach((key, values) -> values.stream().filter(value -> {
            OwsCapabilitiesExtensionProvider provider = (OwsCapabilitiesExtensionProvider)value.get();
            return !provider.hasRelatedOperation() || this.checkIfRelatedOperationIsActivated((OwsCapabilitiesExtensionKey)key, provider.getRelatedOperation());
        }).forEach(value -> this.providers.computeIfAbsent((OwsCapabilitiesExtensionKey)key, Suppliers.asFunction(HashSet::new)).add((Producer<OwsCapabilitiesExtensionProvider>)value)));
    }

    public List<OwsCapabilitiesExtensionProvider> getCapabilitiesExtensionProvider(OwsCapabilitiesExtensionKey key) {
        return this.getAllValidCapabilitiesExtensionProvider(key, (Collection<Producer<OwsCapabilitiesExtensionProvider>>)this.providers.get(key));
    }

    public List<OwsCapabilitiesExtensionProvider> getCapabilitiesExtensionProvider(String service, String version) {
        return this.getCapabilitiesExtensionProvider(new OwsCapabilitiesExtensionKey(service, version));
    }

    private List<OwsCapabilitiesExtensionProvider> getAllValidCapabilitiesExtensionProvider(OwsCapabilitiesExtensionKey key, Collection<Producer<OwsCapabilitiesExtensionProvider>> list) {
        return Optional.ofNullable(list).map(Collection::stream).orElseGet(Stream::empty).map(Producer::get).filter(provider -> !provider.hasRelatedOperation() || this.checkIfRelatedOperationIsActivated(key, provider.getRelatedOperation())).collect(Collectors.toList());
    }

    private boolean checkIfRelatedOperationIsActivated(OwsCapabilitiesExtensionKey key, String relatedOperation) {
        RequestOperatorKey rok = new RequestOperatorKey(key.getService(), key.getVersion(), relatedOperation);
        return this.requestOperatorRepository.isActive(rok);
    }
}

