/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.ds;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public abstract class DatasourceCallback {
    public void onFirstConnection(Connection connection) throws SQLException {
    }

    public Properties onInit(Properties properties) {
        return properties;
    }

    public static DatasourceCallback nullCallback() {
        return new DatasourceCallback(){};
    }

    public static DatasourceCallback chain(final DatasourceCallback first, final DatasourceCallback second) {
        return new DatasourceCallback(){

            @Override
            public void onFirstConnection(Connection connection) throws SQLException {
                first.onFirstConnection(connection);
                second.onFirstConnection(connection);
            }

            @Override
            public Properties onInit(Properties properties) {
                return second.onInit(first.onInit(properties));
            }
        };
    }
}

