/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.convert;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.n52.janmayen.Comparables;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;

public class RequestResponseModifierKey
implements Comparable<RequestResponseModifierKey> {
    private final String service;
    private final String version;
    private Optional<Class<? extends OwsServiceRequest>> request;
    private Optional<Class<? extends OwsServiceResponse>> response;

    public RequestResponseModifierKey(String service, String version, OwsServiceRequest request) {
        this(service, version, request, null);
    }

    public RequestResponseModifierKey(String service, String version, OwsServiceRequest request, OwsServiceResponse response) {
        this(service, version, RequestResponseModifierKey.getClass(request), RequestResponseModifierKey.getClass(response));
    }

    public RequestResponseModifierKey(String service, String version, Class<? extends OwsServiceRequest> request) {
        this(service, version, request, null);
    }

    public RequestResponseModifierKey(String service, String version, Class<? extends OwsServiceRequest> request, Class<? extends OwsServiceResponse> response) {
        this(service, version, Optional.ofNullable(request), Optional.ofNullable(response));
    }

    public RequestResponseModifierKey(String service, String version, Optional<Class<? extends OwsServiceRequest>> request, Optional<Class<? extends OwsServiceResponse>> response) {
        this.service = Optional.ofNullable(service).orElse("");
        this.version = Optional.ofNullable(version).orElse("");
        this.request = Objects.requireNonNull(request);
        this.response = Objects.requireNonNull(response);
    }

    public String getService() {
        return this.service;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSetService() {
        return !Strings.isNullOrEmpty((String)this.getService());
    }

    public boolean isSetVersion() {
        return !Strings.isNullOrEmpty((String)this.getVersion());
    }

    public Class<? extends OwsServiceRequest> getRequest() {
        return this.request.orElse(null);
    }

    public boolean isSetRequest() {
        return this.request.isPresent();
    }

    public Class<? extends OwsServiceResponse> getResponse() {
        return this.response.orElse(null);
    }

    public boolean isSetResponse() {
        return this.response.isPresent();
    }

    public String toString() {
        return String.format("%s[service=%s, service=%s, request=%s, response=%s]", this.getClass().getSimpleName(), this.getService(), this.getVersion(), this.isSetRequest() ? this.getRequest().getClass().getSimpleName() : "", this.isSetResponse() ? this.getResponse().getClass().getSimpleName() : "");
    }

    @Override
    public int compareTo(RequestResponseModifierKey o) {
        Comparator stringComparator = Comparables.allowNull(String::compareTo);
        Comparator classComparator = Comparables.allowNull((a, b) -> a == b ? 0 : a.getName().compareTo(b.getName()));
        return Comparator.comparing(RequestResponseModifierKey::getService, stringComparator).thenComparing(RequestResponseModifierKey::getVersion, stringComparator).thenComparing(RequestResponseModifierKey::getRequest, classComparator).thenComparing(RequestResponseModifierKey::getResponse, classComparator).compare(this, o);
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            RequestResponseModifierKey other = (RequestResponseModifierKey)o;
            return Objects.equals(this.getService(), other.getService()) && Objects.equals(this.getVersion(), other.getVersion()) && Objects.equals(this.getRequest(), other.getRequest()) && Objects.equals(this.getResponse(), other.getResponse());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.getService(), this.getVersion(), this.getRequest().getClass());
        if (this.isSetResponse()) {
            return Objects.hash(hashCode, this.getResponse().getClass());
        }
        return hashCode;
    }

    private static <T> Optional<Class<? extends T>> getClass(T t) {
        return Optional.ofNullable(t).map(x -> x.getClass());
    }
}

