/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.config.spring;

import org.n52.janmayen.lifecycle.Constructable;
import org.n52.janmayen.lifecycle.Destroyable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.core.PriorityOrdered;

public class LifecycleBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
PriorityOrdered {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleBeanPostProcessor.class);
    private int order = Integer.MAX_VALUE;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof Constructable) {
            try {
                ((Constructable)bean).init();
            }
            catch (Throwable t) {
                throw new BeanInitializationException("Couldn't counstruct bean " + beanName, t);
            }
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) {
        if (bean instanceof Destroyable) {
            try {
                ((Destroyable)bean).destroy();
            }
            catch (Throwable t) {
                LOG.error("Couldn't invoke destroy method on " + beanName, t);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public boolean requiresDestruction(Object bean) {
        return bean instanceof Destroyable;
    }
}

