/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.config.spring;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.inject.Inject;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.SettingsService;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ConfiguringBeanPostProcessor
implements BeanPostProcessor {
    private SettingsService settingsService;

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        try {
            this.settingsService.configure(bean);
        }
        catch (ConfigurationError t) {
            throw new BeanInitializationException("Couldn't set settings on bean " + beanName, (Throwable)t);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }
}

